document.addEventListener('DOMContentLoaded', () => {
    alert("JS chargé (geoloc.js)"); // debug visible immédiat

    const geolocateButton = document.querySelector('.geolocation-button');
    const farmerList = document.querySelector('.farmer-list');
    const distancesInfo = document.querySelector('.distances-info');

    if (!geolocateButton || !farmerList) return;

    geolocateButton.addEventListener('click', () => {
        if (!navigator.geolocation) {
            alert("Géolocalisation non supportée.");
            return;
        }

        geolocateButton.disabled = true;
        geolocateButton.innerHTML = '⏳ Localisation...';

        navigator.geolocation.getCurrentPosition(async (position) => {
            const userLat = position.coords.latitude;
            const userLng = position.coords.longitude;

            distancesInfo.style.display = 'block';

            const items = document.querySelectorAll('.farmer-item');
            const distances = [];

            const fetchPromises = Array.from(items).map(async item => {
                const id = item.getAttribute('data-id');
                const coords = item.getAttribute('data-coordinates');
                const [farmLat, farmLng] = coords.split(',').map(parseFloat);

                const url = '/modules/mod_agriculteur_liste/api/get-distance.php?start=' + userLng + ',' + userLat + '&end=' + farmLng + ',' + farmLat;
                console.log('[DEBUG URL]', url);

                try {
                    const res = await fetch(url);
                    const json = await res.json();
                    console.log('[RETOUR PHP]', json);

                    const distance = json?.features?.[0]?.properties?.summary?.distance;
                    console.log('[DISTANCE KM]', distance);

                    if (!distance) return;

                    const distanceKm = distance / 1000;
                    distances.push({ id, distance: distanceKm, element: item });
                    item.setAttribute('data-distance', distanceKm);

                    const distEl = document.getElementById('distance-' + id);
                    const valueEl = distEl?.querySelector('.distance-value');
                    console.log('[DOM]', distEl, valueEl);

                    if (valueEl) {
                        valueEl.textContent = distanceKm.toFixed(1);
                        distEl.style.display = 'block';
                    }
                } catch (err) {
                    console.error(\"Erreur lors du calcul de distance via PHP :\", err);
                }
            });

            await Promise.all(fetchPromises);

            distances.sort((a, b) => a.distance - b.distance);
            distances.forEach(d => farmerList.appendChild(d.element.parentNode));

            geolocateButton.disabled = false;
            geolocateButton.innerHTML = '📍 Trouver les agriculteurs proches de moi';
        }, () => {
            alert(\"Impossible d’obtenir votre position.\");
            geolocateButton.disabled = false;
            geolocateButton.innerHTML = '📍 Trouver les agriculteurs proches de moi';
        });
    });
});
