<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_categories
 *
 * @copyright   Copyright (C) 2025 Votre Nom. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */


defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;


// Configurer les catégories et leurs informations
// Utiliser les valeurs exactes pour les 6 catégories officielles
$categories = [
    [
        'id' => 'tous',
        'title' => 'A côté de moi',
        'icon' => 'vente-directe.png',
        'description' => 'Découvrez les entreprises labellisées AB autour de vous, classées par distance pour trouver les plus proches en un clin d\'œil.',
        'filter' => '' // Pas de filtre pour "A côté de moi", afficher tous les agriculteurs
    ],
    [
        'id' => 'agriculteur',
        'title' => 'Agriculteur',
        'icon' => 'vente-directe.png',
        'description' => 'Découvrez les agriculteurs locaux qui cultivent des produits frais et de qualité.',
        'filter' => 'Agriculteur' 
    ],
    [
        'id' => 'commerce-bio',
        'title' => 'Commerce bio',
        'icon' => 'commerces.png',
        'description' => 'Les commerces bio proches de chez vous. Un moyen simple et pratique de consommer local et responsable au quotidien.',
        'filter' => 'Commerce bio'
    ],
    [
        'id' => 'transformateur',
        'title' => 'Transformateur',
        'icon' => 'transformateur.png',
        'description' => 'Découvrez ceux qui transforment localement fruits, légumes, épices ou autres trésors de l\'île en produits artisanaux de qualité.',
        'filter' => 'Transformateur'
    ],
    [
        'id' => 'restaurant',
        'title' => 'Restaurateur',
        'icon' => 'restau.png',
        'description' => 'Ils mettent à l\'honneur les produits locaux et bio. Savourez une cuisine engagée, authentique et ancrée dans les saveurs réunionnaises.',
        'filter' => 'Restaurateur'
    ],
    [
        'id' => 'table',
        'title' => 'Tables et gîte',
        'icon' => 'tables-et-gites.png',
        'description' => 'Les tables d\'hôtes et gîtes pour une immersion authentique dans la gastronomie et l\'accueil typique réunionnais.',
        'filter' => 'Tables et gîte'
    ],
    [
        'id' => 'autre',
        'title' => 'Autres',
        'icon' => 'autre.png',
        'description' => 'Autres initiatives engagées, en lien avec la bio, la transformation locale ou le développement durable à La Réunion.',
        'filter' => 'Autres'
    ]
];

// Récupérer l'URL de base du site
$root = Uri::root();
$mediaPath = $root . 'media/mod_agriculteur_liste/images/';

// Récupérer l'ID de la page des agriculteurs
$agriculteurPageId = $params->get('agriculteur_page_id', '50');

// Construire l'URL de base pour les liens vers la page des agriculteurs
$baseUrl = $root . 'index.php?option=com_sppagebuilder&view=page&id=' . $agriculteurPageId;

// Déterminer si on doit afficher la vue liste ou grille
$activeView = $params->get('default_view', 'list');

// Charger les styles CSS
$document = Factory::getDocument();
$document->addStyleSheet($root . 'media/mod_agriculteur_categories/css/style.css');

// Inclure le template d'affichage
require ModuleHelper::getLayoutPath('mod_agriculteur_categories', $params->get('layout', 'default'));