<?php
// No direct access
defined('_JEXEC') or die;
?>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: Arial, sans-serif;
}

.bio-container {
    position: relative;
    width: 100%;
    height: 100vh;
    display: flex;
    flex-direction: column;
    align-items: center;
    background-color: #38611d;
}

.bio-background-image {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
    z-index: 0;
}

.bio-logo-container {
    position: relative;
    text-align: center;
    margin-top: 120px;
    z-index: 10;
}

.bio-logo-image {
    width: 220px;
    height: auto;
}

.bio-menu-container {
    position: absolute;
    display: flex;
    justify-content: space-around;
    width: 100%;
    max-width: 600px;
    bottom: 25vh;
    z-index: 10;
    padding: 0 20px;
}

.bio-menu-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    width: 120px;
    transition: transform 0.2s;
}

.bio-menu-icon {
    width: 80px;
    height: 80px;
    display: flex;
    justify-content: center;
    align-items: center;
    margin-bottom: 15px;
    position: relative;
    overflow: hidden;
}

.bio-menu-icon::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    transform: scale(0);
    transition: transform 0.5s cubic-bezier(0.25, 0.46, 0.45, 0.94);
}

.bio-menu-item:active .bio-menu-icon::before {
    transform: scale(1.5);
    opacity: 0;
    transition: transform 0.6s, opacity 0.6s;
}

.bio-menu-item:active {
    transform: scale(0.92);
}

.bio-menu-icon img {
    width: 80px;
    height: 80px;
    transition: transform 0.3s;
}

.bio-menu-item:active .bio-menu-icon img {
    transform: scale(0.9);
}

.bio-menu-text {
    color: #34643d;
    font-size: 1.1rem;
    text-align: center;
    font-weight: 500;
    white-space: nowrap;
    transition: color 0.3s;
}

.bio-menu-item:active .bio-menu-text {
    color: #ffffff;
}
</style>

<div class="bio-container">
    <!-- Image de fond -->
    <img src="<?php echo JURI::root(); ?>media/mod_agriculteur_liste/images/fond-vert.jpg" alt="Fond" class="bio-background-image">
    
    <!-- Logo -->
    <div class="bio-logo-container">
        <img src="<?php echo JURI::root(); ?>media/mod_agriculteur_liste/images/logo-labiolela.png" alt="Labioléla mascotte" class="bio-logo-image">
    </div>

    <!-- Menu -->
    <div class="bio-menu-container">
        <a href="<?php echo JURI::root(); ?>component/sppagebuilder/page/52" class="bio-menu-item">
            <div class="bio-menu-icon">
                <img src="<?php echo JURI::root(); ?>media/mod_agriculteur_liste/images/recherche.png" alt="Recherche bio">
            </div>
            <div class="bio-menu-text">Recherche Bio</div>
        </a>
        <a href="https://monapplicommerciale.com/var/apps/browser/index-prod.html#/67d10e93df901/folder2/mobile_list/index/value_id/343/category_id//layout_id/" class="bio-menu-item" id="reunion-bio-link">
            <div class="bio-menu-icon">
                <img src="<?php echo JURI::root(); ?>media/mod_agriculteur_liste/images/agriculteur.png" alt="La Réunion Bio">
            </div>
            <div class="bio-menu-text">La Réunion Bio</div>
        </a>
    </div>
</div>