<?php
defined('_JEXEC') or die;

use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Factory;

// Récupérer le numéro de page de retour
$app = Factory::getApplication();
$pageRetour = $app->input->getInt('page_retour', 1);
?>

<main class="container-fluid p-0 agriculteur-profil">
    <!-- Header avec photo de couverture et bouton incrusté à droite milieu -->
    <?php if(!empty($profileData['photo_couverture']) || !empty($profileData['photo_couverture_url'])): ?>
    <div class="profile-header">
        <?php
        $coverImageUrl = !empty($profileData['photo_couverture_url']) 
            ? $profileData['photo_couverture_url'] 
            : $helper->getUploadPath($profileData['photo_couverture']);
        ?>
        <img src="<?php echo $coverImageUrl; ?>" alt="Photo de couverture" class="cover-photo">

        <!-- Boutons à droite milieu -->
        <div class="buttons-container">
            <?php if(!empty($profileData['geolocalisation'])): ?>
            <a href="<?php echo $helper->generateGoogleMapsLink($profileData['geolocalisation']); ?>" 
               class="btn btn-success map-button yaller-button" 
               target="_blank" 
               rel="noopener noreferrer"
               data-coordinates="<?php echo htmlspecialchars($profileData['geolocalisation']); ?>">
                <i class="fas fa-map-marker-alt me-2"></i>Y aller <span class="distance-display"></span>
            </a>
            <?php endif; ?>
            <a href="<?php echo Uri::root(); ?>index.php?option=com_sppagebuilder&view=page&id=50&page=<?php echo $pageRetour; ?>" class="btn btn-success btn-sm map-button retour-button">
                <i class="fas fa-arrow-left me-1"></i> Retour
            </a>
        </div>

        <!-- Logo -->
        <?php if(!empty($profileData['logo']) || !empty($profileData['logo_url'])): ?>
        <div class="logo-container">
            <?php
            $logoUrl = !empty($profileData['logo_url']) 
                ? $profileData['logo_url'] 
                : $helper->getUploadPath($profileData['logo']);
            ?>
            <img src="<?php echo $logoUrl; ?>" alt="Logo" class="logo-img">
        </div>
        <?php endif; ?>

        <!-- Header Content avec dégradé -->
        <div class="header-content">
            <h1 class="farm-title"><?php echo htmlspecialchars($profileData['societe']); ?></h1>
            <p class="mb-0">
                <?php echo htmlspecialchars($profileData['prenom'] . ' ' . $profileData['nom']); ?>
                <?php if(!empty($profileData['status'])): ?>
                - <span class="badge bg-secondary"><?php echo htmlspecialchars($profileData['status']); ?></span>
                <?php endif; ?>
            </p>
        </div>
    </div>
    <?php else: ?>
    <!-- Header sans photo de couverture -->
    <div class="profile-header-simple">
        <?php if(!empty($profileData['logo']) || !empty($profileData['logo_url'])): ?>
        <div class="logo-container-simple">
            <?php
            $logoUrl = !empty($profileData['logo_url']) 
                ? $profileData['logo_url'] 
                : $helper->getUploadPath($profileData['logo']);
            ?>
            <img src="<?php echo $logoUrl; ?>" alt="Logo" class="logo-img">
        </div>
        <?php endif; ?>

        <div class="buttons-container-simple">
            <?php if(!empty($profileData['geolocalisation'])): ?>
            <a href="<?php echo $helper->generateGoogleMapsLink($profileData['geolocalisation']); ?>" 
               class="btn btn-success map-button yaller-button" 
               target="_blank" 
               rel="noopener noreferrer"
               data-coordinates="<?php echo htmlspecialchars($profileData['geolocalisation']); ?>">
                <i class="fas fa-map-marker-alt me-2"></i>Y aller <span class="distance-display"></span>
            </a>
            <?php endif; ?>
            <a href="<?php echo Uri::root(); ?>index.php?option=com_sppagebuilder&view=page&id=50&page=<?php echo $pageRetour; ?>" class="btn btn-success btn-sm map-button retour-button">
                <i class="fas fa-arrow-left me-1"></i> Retour
            </a>
        </div>

        <div class="header-content-simple">
            <h1 class="farm-title"><?php echo htmlspecialchars($profileData['societe']); ?></h1>
            <p class="mb-0">
                <?php echo htmlspecialchars($profileData['prenom'] . ' ' . $profileData['nom']); ?>
                <?php if(!empty($profileData['status'])): ?>
                - <span class="badge bg-secondary"><?php echo htmlspecialchars($profileData['status']); ?></span>
                <?php endif; ?>
            </p>
        </div>
    </div>
    <?php endif; ?>

    <!-- Script pour le calcul de la distance -->
    <?php if(!empty($profileData['geolocalisation'])): ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        if ('geolocation' in navigator) {
            navigator.geolocation.getCurrentPosition(function(position) {
                const userLat = position.coords.latitude;
                const userLon = position.coords.longitude;
                const coordinates = document.querySelector('.yaller-button').dataset.coordinates;
                const [farmLat, farmLon] = coordinates.split(',').map(Number);
                
                // Utiliser le service Distance Matrix de Google Maps
                const service = new google.maps.DistanceMatrixService();
                
                service.getDistanceMatrix({
                    origins: [{ lat: userLat, lng: userLon }],
                    destinations: [{ lat: farmLat, lng: farmLon }],
                    travelMode: google.maps.TravelMode.DRIVING,
                    unitSystem: google.maps.UnitSystem.METRIC
                }, function(response, status) {
                    if (status === 'OK' && response.rows[0].elements[0].status === 'OK') {
                        const distance = response.rows[0].elements[0].distance.text;
                        document.querySelectorAll('.distance-display').forEach(function(el) {
                            el.textContent = ` (${distance})`;
                        });
                    }
                });
            });
        }
    });
    </script>
    <script async defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAjsOoV0528RtrLFvylBrsypk0Z3qik5RI"></script>
    <?php endif; ?>

    <div class="content-wrapper">
        <div class="content-container">
            <div class="info-card" style="padding-left:20px;padding-right:20px;">
                <!-- Réception du public -->
                <h2 class="section-title">Réception du public</h2>
                <?php if(!empty($profileData['produits_semaine'])): ?>
                <div class="mb-4">
                    <h3 class="h5 mb-3">Disponible en ce moment :</h3>
                    <div class="products-week">
                        <?php echo nl2br(htmlspecialchars($profileData['produits_semaine'])); ?>
                    </div>
                </div>
                <?php endif; ?>

                <?php if(!empty($profileData['jours_reception'])): ?>
                <div class="mb-3">
                    <?php
                    $joursComplets = is_array($profileData['jours_reception']) ? implode("\n", $profileData['jours_reception']) : $profileData['jours_reception'];
                    foreach(preg_split('/\r\n|\r|\n/', $joursComplets) as $jour): 
                        if(trim($jour)):
                    ?>
                        <span class="badge bg-success me-2 mb-2"><?php echo htmlspecialchars(trim($jour)); ?></span>
                    <?php endif; endforeach; ?>
                </div>
                <?php endif; ?>


                <?php if(!empty($profileData['horaires_reception'])): ?>
                <div>
                    <?php echo nl2br(htmlspecialchars($profileData['horaires_reception'])); ?>
                </div>
                <?php endif; ?>
            </div>

            <!-- Contact Info Card -->
            <div class="info-card">
                <h2 class="section-title">Contact</h2>
                <ul class="list-unstyled">
                    <?php if(!empty($profileData['email'])): ?>
                    <li class="mb-2">
                        <i class="fas fa-envelope contact-icon"></i>
                        <a href="mailto:<?php echo htmlspecialchars($profileData['email']); ?>"><?php echo htmlspecialchars($profileData['email']); ?></a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(!empty($profileData['telephone'])): ?>
                    <li class="mb-2">
                        <i class="fas fa-phone contact-icon"></i>
                        <a href="tel:<?php echo htmlspecialchars(preg_replace('/\s+/', '', $profileData['telephone'])); ?>"><?php echo htmlspecialchars($profileData['telephone']); ?></a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(!empty($profileData['Site-internet'])): ?>
                    <li class="mb-2">
                        <i class="fas fa-globe contact-icon"></i>
                        <a href="<?php echo $helper->formatUrl($profileData['Site-internet']); ?>" target="_blank"><?php echo htmlspecialchars($profileData['Site-internet']); ?></a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(!empty($profileData['facebook'])): ?>
                    <li class="mb-2">
                        <i class="fab fa-facebook contact-icon"></i>
                        <a href="<?php echo $helper->formatUrl($profileData['facebook']); ?>" target="_blank">Facebook</a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if(!empty($profileData['full_address'])): ?>
                    <li class="mb-3">
                        <i class="fas fa-map-marker-alt contact-icon"></i>
                        <span><?php echo htmlspecialchars($profileData['full_address']); ?></span>
                    </li>
                    <?php endif; ?>
                </ul>
            </div>
            
            <!-- Products -->
            <?php
            $hasProducts = !empty($profileData['all_legumes']) || 
                        !empty($profileData['all_fruits']) ||
                        !empty($profileData['cafe_vanille_cacao']) ||
                        !empty($profileData['all_plantes']) ||
                        !empty($profileData['fleurs_horticulture']);
                        
            if($hasProducts):
            ?>
            <div class="info-card">
                <h2 class="section-title">Nos produits</h2>
                
                <?php if(!empty($profileData['all_legumes'])): ?>
                <div class="products-section">
                    <h3>Légumes</h3>
                    <div class="product-list">
                        <?php 
                        $formattedLegumes = array();
                        foreach($profileData['all_legumes'] as $legume) {
                            if(trim($legume) != '') {
                                $formattedLegumes[] = trim($legume);
                            }
                        }
                        if(!empty($formattedLegumes)) {
                            echo '<div class="badge-container">';
                            // Un badge par produit au lieu d'un seul long
                            foreach($formattedLegumes as $legume) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($legume) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['all_fruits'])): ?>
                <div class="products-section">
                    <h3>Fruits</h3>
                    <div class="product-list">
                        <?php 
                        $formattedFruits = array();
                        foreach($profileData['all_fruits'] as $fruit) {
                            if(trim($fruit) != '') {
                                $formattedFruits[] = trim($fruit);
                            }
                        }
                        if(!empty($formattedFruits)) {
                            echo '<div class="badge-container">';
                            // Un badge par produit au lieu d'un seul long
                            foreach($formattedFruits as $fruit) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($fruit) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['cafe_vanille_cacao'])): ?>
                <div class="products-section">
                    <h3>Café, Vanille, Cacao</h3>
                    <div class="product-list">
                        <?php 
                        $formattedProducts = array();
                        foreach($profileData['cafe_vanille_cacao'] as $product) {
                            if(trim($product) != '') {
                                $formattedProducts[] = trim($product);
                            }
                        }
                        if(!empty($formattedProducts)) {
                            echo '<div class="badge-container">';
                            // Un badge par produit au lieu d'un seul long
                            foreach($formattedProducts as $product) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($product) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['all_plantes'])): ?>
                <div class="products-section">
                    <h3>Plantes aromatiques et médicinales</h3>
                    <div class="product-list">
                        <?php 
                        $formattedPlantes = array();
                        foreach($profileData['all_plantes'] as $plante) {
                            if(trim($plante) != '') {
                                $formattedPlantes[] = trim($plante);
                            }
                        }
                        if(!empty($formattedPlantes)) {
                            echo '<div class="badge-container">';
                            // Un badge par produit au lieu d'un seul long
                            foreach($formattedPlantes as $plante) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($plante) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['fleurs_horticulture'])): ?>
                <div class="products-section">
                    <h3>Fleurs et Horticulture</h3>
                    <div class="product-list">
                        <?php 
                        $formattedFleurs = array();
                        foreach($profileData['fleurs_horticulture'] as $fleur) {
                            if(trim($fleur) != '') {
                                $formattedFleurs[] = trim($fleur);
                            }
                        }
                        if(!empty($formattedFleurs)) {
                            echo '<div class="badge-container">';
                            // Un badge par produit au lieu d'un seul long
                            foreach($formattedFleurs as $fleur) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($fleur) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>

            <!-- À propos -->
            <?php if(!empty($profileData['description'])): ?>
            <div class="info-card">
                <h2 class="section-title">À propos</h2>
                <div><?php echo nl2br(htmlspecialchars($profileData['description'])); ?></div>
            </div>
            <?php endif; ?>
            
            <!-- Section Activités -->
            <?php
            $hasActivities = !empty($profileData['categories']) || 
                            !empty($profileData['type_agriculture']) || 
                            !empty($profileData['cultures']) || 
                            !empty($profileData['cultures_fourrageres']) ||
                            !empty($profileData['type_elevage']) || 
                            !empty($profileData['autres_activites']);
            
            if($hasActivities):
            ?>
            <div class="info-card">
                <h2 class="section-title">Activités</h2>
                
                <?php if(!empty($profileData['categories'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Catégories</h3>
                    <div class="product-list">
                        <?php 
                        $formattedCategories = array();
                        foreach($profileData['categories'] as $category) {
                            if(trim($category) !== '') {
                                $formattedCategories[] = trim($category);
                            }
                        }
                        if(!empty($formattedCategories)) {
                            echo '<div class="badge-container">';
                            // Un badge par catégorie au lieu d'un seul long
                            foreach($formattedCategories as $category) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($category) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['type_agriculture'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Type d'agriculture</h3>
                    <div class="product-list">
                        <?php 
                        $formattedTypes = array();
                        foreach($profileData['type_agriculture'] as $type) {
                            if(trim($type) !== '') {
                                $formattedTypes[] = trim($type);
                            }
                        }
                        if(!empty($formattedTypes)) {
                            echo '<div class="badge-container">';
                            // Un badge par type au lieu d'un seul long
                            foreach($formattedTypes as $type) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($type) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['cultures'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Cultures</h3>
                    <div class="product-list">
                        <?php 
                        $formattedCultures = array();
                        foreach($profileData['cultures'] as $culture) {
                            if(trim($culture) !== '') {
                                $formattedCultures[] = trim($culture);
                            }
                        }
                        if(!empty($formattedCultures)) {
                            echo '<div class="badge-container">';
                            // Un badge par culture au lieu d'un seul long
                            foreach($formattedCultures as $culture) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($culture) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['cultures_fourrageres'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Cultures fourragères</h3>
                    <div class="product-list">
                        <?php 
                        $formattedCulturesFourrageres = array();
                        foreach($profileData['cultures_fourrageres'] as $culture) {
                            if(trim($culture) !== '') {
                                $formattedCulturesFourrageres[] = trim($culture);
                            }
                        }
                        if(!empty($formattedCulturesFourrageres)) {
                            echo '<div class="badge-container">';
                            // Un badge par culture au lieu d'un seul long
                            foreach($formattedCulturesFourrageres as $culture) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($culture) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['type_elevage'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Type d'élevage</h3>
                    <div class="product-list">
                        <?php 
                        $formattedElevages = array();
                        foreach($profileData['type_elevage'] as $elevage) {
                            if(trim($elevage) !== '') {
                                $formattedElevages[] = trim($elevage);
                            }
                        }
                        if(!empty($formattedElevages)) {
                            echo '<div class="badge-container">';
                            // Un badge par type d'élevage au lieu d'un seul long
                            foreach($formattedElevages as $elevage) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($elevage) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($profileData['autres_activites'])): ?>
                <div class="mb-3">
                    <h3 class="h5">Autres activités</h3>
                    <div class="product-list">
                        <?php 
                        $formattedActivites = array();
                        foreach($profileData['autres_activites'] as $activite) {
                            if(trim($activite) !== '') {
                                $formattedActivites[] = trim($activite);
                            }
                        }
                        if(!empty($formattedActivites)) {
                            echo '<div class="badge-container">';
                            // Un badge par activité au lieu d'un seul long
                            foreach($formattedActivites as $activite) {
                                echo '<span class="badge category-badge">' . htmlspecialchars($activite) . '</span>';
                            }
                            echo '</div>';
                        }
                        ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
            
            <!-- Galerie Photos -->
            <?php if(!empty($profileData['galerie_photos']) || !empty($profileData['galerie_photos_urls'])): ?>
            <div class="info-card">
                <h2 class="section-title">Galerie photos</h2>
                <div class="row gallery-container">
                    <?php
                    if (!empty($profileData['galerie_photos_urls'])) {
                        $photoUrls = explode(',', $profileData['galerie_photos_urls']);
                        foreach($photoUrls as $photoUrl): 
                            $photoUrl = trim($photoUrl);
                            if(!empty($photoUrl)):
                    ?>
                        <div class="col-md-4 col-6 mb-4">
                            <a href="<?php echo $photoUrl; ?>" class="gallery-item" data-fancybox="gallery">
                                <img src="<?php echo $photoUrl; ?>" alt="Photo de la ferme" class="img-fluid rounded">
                            </a>
                        </div>
                    <?php 
                            endif;
                        endforeach;
                    } else if (!empty($profileData['galerie_photos'])) {
                        $photoGallery = explode(',', $profileData['galerie_photos']);
                        foreach($photoGallery as $photo): 
                            $photo = trim($photo);
                            if(!empty($photo)):
                                if (strpos($photo, '/home/') !== false) {
                                    $parts = explode('/', $photo);
                                    $photo = end($parts);
                                }
                                $photoUrl = 'https://labiolela.re/components/com_rsform/uploads/' . $photo;
                    ?>
                        <div class="col-md-4 col-6 mb-4">
                            <a href="<?php echo $photoUrl; ?>" class="gallery-item" data-fancybox="gallery">
                                <img src="<?php echo $photoUrl; ?>" alt="Photo de la ferme" class="img-fluid rounded">
                            </a>
                        </div>
                    <?php 
                            endif;
                        endforeach;
                    }
                    ?>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Vidéos -->
            <?php if(!empty($profileData['video_v']) || !empty($profileData['video_i'])): ?>
            <div class="info-card">
                <h2 class="section-title">Vidéos</h2>
                
                <?php if(!empty($profileData['video_v'])): 
                    $embedUrl = $helper->getVideoEmbedUrl($profileData['video_v']);
                    if(!empty($embedUrl)):
                ?>
                <div class="video-container mb-4">
                    <iframe src="<?php echo $embedUrl; ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
                <?php 
                    endif;
                endif; 
                ?>
                
                <?php if(!empty($profileData['video_i'])): 
                    $embedUrl = $helper->getVideoEmbedUrl($profileData['video_i']);
                    if(!empty($embedUrl)):
                ?>
                <div class="video-container">
                    <iframe src="<?php echo $embedUrl; ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
                <?php 
                    endif;
                endif; 
                ?>
            </div>
            <?php endif; ?>
            
            <!-- Status et Marchés -->
            <div class="row">
                <div class="col-md-6">
                    <?php 
                    $hasStatus = !empty($profileData['status']) || !empty($profileData['autre_status']);
                    if($hasStatus): 
                        $statutText = !empty($profileData['autre_status']) 
                            ? $profileData['autre_status'] 
                            : $profileData['status'];
                    ?>
                    <div class="info-card">
                        <h2 class="section-title">Statut</h2>
                        <p><?php echo htmlspecialchars($statutText); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
                
                <div class="col-md-6">
                    <?php if(!empty($profileData['marches'])): ?>
                    <div class="info-card">
                        <h2 class="section-title">Marchés</h2>
                        <div><?php echo nl2br(htmlspecialchars($profileData['marches'])); ?></div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</main>