<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_categories
 *
 * @copyright   Copyright (C) 2025 Votre Nom. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;
?>

<div class="agriculteur-categories-container">
    <!-- Barre de navigation supérieure avec boutons -->
    <div class="top-navigation-bar">
        <a href="https://monapplicommerciale.com/67d10e93df901" class="nav-button back-button">
            <i class="fas fa-arrow-left"></i>
        </a>
        <div class="view-buttons">
            <button id="list-view-button" class="nav-button <?php echo ($activeView == 'list') ? 'active' : ''; ?>">
                <i class="fas fa-list"></i>
            </button>
            <button id="grid-view-button" class="nav-button <?php echo ($activeView == 'grid') ? 'active' : ''; ?>">
                <i class="fas fa-th"></i>
            </button>
        </div>
    </div>

    <!-- Débogage des liens (masqué pour l'utilisateur final) -->
    <div style="display:none;">
        <h4>Débogage des liens de catégories</h4>
        <ul>
            <?php foreach ($categories as $category): ?>
                <?php 
                // Construction du lien vers la liste
                $categoryUrl = $baseUrl . '&view_mode=list';
                if (!empty($category['filter'])) {
                    $categoryUrl .= '&category=' . urlencode($category['filter']);
                }
                ?>
                <li>
                    <strong>ID:</strong> <?php echo $category['id']; ?><br>
                    <strong>Titre:</strong> <?php echo $category['title']; ?><br>
                    <strong>Filtre:</strong> <?php echo $category['filter']; ?><br>
                    <strong>URL:</strong> <a href="<?php echo $categoryUrl; ?>"><?php echo $categoryUrl; ?></a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <!-- Vue liste -->
    <div id="list-view" class="view-container <?php echo ($activeView == 'list') ? 'active-view' : ''; ?>">
        <ul class="category-list">
            <?php foreach ($categories as $category): ?>
                <?php 
                // Construction du lien vers la liste
                // Pour "A côté de moi", pas de filtre de catégorie
                // Pour les autres, ajouter le paramètre category
                $categoryUrl = $baseUrl . '&view_mode=list';
                if (!empty($category['filter'])) {
                    $categoryUrl .= '&category=' . urlencode($category['filter']);
                }
                ?>
                <li>
                    <a href="<?php echo $categoryUrl; ?>" class="category-item">
                        <div class="category-content">
                            <img src="<?php echo $mediaPath . $category['icon']; ?>" alt="<?php echo htmlspecialchars($category['title']); ?>" class="category-image">
                            <div class="category-info">
                                <h3 class="category-name"><?php echo htmlspecialchars($category['title']); ?></h3>
                                <p class="category-description"><?php echo htmlspecialchars($category['description']); ?></p>
                            </div>
                        </div>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <!-- Vue grille -->
    <div id="grid-view" class="view-container <?php echo ($activeView == 'grid') ? 'active-view' : ''; ?>">
        <div class="category-grid">
            <?php foreach ($categories as $category): ?>
                <?php 
                // Construction du lien vers la liste
                // Pour "A côté de moi", pas de filtre de catégorie
                // Pour les autres, ajouter le paramètre category
                $categoryUrl = $baseUrl . '&view_mode=grid';
                if (!empty($category['filter'])) {
                    $categoryUrl .= '&category=' . urlencode($category['filter']);
                }
                ?>
                <a href="<?php echo $categoryUrl; ?>" class="grid-item">
                    <div class="grid-item-content">
                        <div class="grid-item-image-container">
                            <img src="<?php echo $mediaPath . $category['icon']; ?>" alt="<?php echo htmlspecialchars($category['title']); ?>" class="grid-item-image">
                        </div>
                        <div class="grid-item-info">
                            <h3 class="grid-item-name"><?php echo htmlspecialchars($category['title']); ?></h3>
                        </div>
                    </div>
                </a>
            <?php endforeach; ?>
        </div>
    </div>
</div>

<style>
/* Styles pour la barre de navigation supérieure */
.top-navigation-bar {
    display: flex;
    justify-content: space-between;
    align-items: center;
    background-color: #356d21; /* Vert foncé comme sur le screenshot */
    padding: 10px 15px;
    position: sticky;
    top: 0;
    z-index: 1000;
    color: white;
    margin-bottom: 10px;
}

.nav-button {
    background: none;
    border: none;
    color: white;
    font-size: 1.4rem;
    cursor: pointer;
    padding: 8px;
    display: inline-flex;
    justify-content: center;
    align-items: center;
    position: relative;
}

.nav-button.active {
    color: #ffcc00; /* Bouton actif en jaune */
}

.back-button {
    font-size: 1.6rem;
    text-decoration: none;
}

.view-buttons {
    display: flex;
    gap: 15px;
}

/* Conteneur des vues */
.view-container {
    display: none;
}

.active-view {
    display: block;
}

/* Vue liste */
.category-list {
    padding: 0;
    margin: 0;
    list-style: none;
}

.category-item {
    display: block;
    background-color: white;
    margin-bottom: 15px;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    text-decoration: none !important;
    color: inherit !important;
    transition: transform 0.2s, box-shadow 0.2s;
}

.category-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.category-content {
    display: flex;
    align-items: center;
    min-height: 100px;
    padding: 10px;
}

.category-image {
    width: 100px;
    height: 100px;
    object-fit: contain;
    flex-shrink: 0;
    padding: 5px;
}

.category-info {
    flex-grow: 1;
    padding: 15px;
    overflow: hidden;
}

.category-name {
    font-weight: bold !important;
    color: #3c8f44 !important;
    margin: 0 0 8px 0 !important;
    font-size: 1.2rem !important;
}

.category-description {
    margin: 0 !important;
    font-size: 0.9rem;
    color: #666;
    line-height: 1.4;
}

/* Vue grille */
.category-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 15px;
    margin: 0;
    padding: 0;
}

.grid-item {
    background-color: white;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    text-decoration: none !important;
    color: inherit !important;
    position: relative;
    display: flex;
    flex-direction: column;
    text-align: center;
    transition: transform 0.2s, box-shadow 0.2s;
}

.grid-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.grid-item-content {
    display: flex;
    flex-direction: column;
    height: 100%;
    padding: 15px;
}

.grid-item-image-container {
    padding: 10px;
    display: flex;
    justify-content: center;
    align-items: center;
}

.grid-item-image {
    width: 80px;
    height: 80px;
    object-fit: contain;
}

.grid-item-info {
    padding: 10px 5px;
    flex-grow: 1;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.grid-item-name {
    font-weight: bold !important;
    color: #3c8f44 !important;
    margin: 0 !important;
    font-size: 1rem !important;
    text-align: center;
}

/* Responsive */
@media (max-width: 767px) {
    .category-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 576px) {
    .category-content {
        flex-direction: column;
        text-align: center;
    }
    
    .category-image {
        margin-top: 10px;
    }
    
    .category-info {
        padding: 10px 15px 15px;
    }
    
    .category-description {
        font-size: 0.85rem;
    }
    
    .grid-item-name {
        font-size: 0.9rem !important;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const listViewButton = document.getElementById('list-view-button');
    const gridViewButton = document.getElementById('grid-view-button');
    const listView = document.getElementById('list-view');
    const gridView = document.getElementById('grid-view');
    
    // Fonction pour stocker le mode de vue actuel en localStorage
    function setViewMode(mode) {
        try {
            localStorage.setItem('agriculteur_category_view_mode', mode);
        } catch (e) {
            console.error('Impossible de stocker le mode de vue:', e);
        }
    }
    
    // Récupérer le mode de vue stocké
    function getViewMode() {
        try {
            return localStorage.getItem('agriculteur_category_view_mode');
        } catch (e) {
            return null;
        }
    }
    
    // Appliquer le mode de vue stocké au chargement
    const storedView = getViewMode();
    if (storedView === 'grid') {
        listView.classList.remove('active-view');
        gridView.classList.add('active-view');
        listViewButton.classList.remove('active');
        gridViewButton.classList.add('active');
    } else if (storedView === 'list') {
        listView.classList.add('active-view');
        gridView.classList.remove('active-view');
        listViewButton.classList.add('active');
        gridViewButton.classList.remove('active');
    }
    
    // Gestionnaire d'événement pour le bouton de vue liste
    if (listViewButton) {
        listViewButton.addEventListener('click', function() {
            listView.classList.add('active-view');
            gridView.classList.remove('active-view');
            listViewButton.classList.add('active');
            gridViewButton.classList.remove('active');
            setViewMode('list');
        });
    }
    
    // Gestionnaire d'événement pour le bouton de vue grille
    if (gridViewButton) {
        gridViewButton.addEventListener('click', function() {
            gridView.classList.add('active-view');
            listView.classList.remove('active-view');
            gridViewButton.classList.add('active');
            listViewButton.classList.remove('active');
            setViewMode('grid');
        });
    }
});
</script>