<?php
// Fichier : get-distance.php
// But : interroger OpenRouteService côté serveur pour calculer la distance routière entre 2 points

// Définir que la réponse sera en JSON
header('Content-Type: application/json');

// Vérifie que les paramètres start et end sont fournis
if (!isset($_GET['start']) || !isset($_GET['end'])) {
    echo json_encode(['error' => 'Missing parameters: start and end are required']);
    exit;
}

// Récupère les coordonnées depuis l'URL
$start = $_GET['start']; // Format attendu : "longitude,latitude"
$end   = $_GET['end'];   // Format attendu : "longitude,latitude"

// Ta clé API OpenRouteService (copie-la depuis ton compte)
$apiKey = '5b3ce3597851110001cf62480c7ae4d074084cd6aefd8f3652182e26'; // ⬅️ remplace ça par ta vraie clé

// Construction de l'URL de l'API OpenRouteService
$url = "https://api.openrouteservice.org/v2/directions/driving-car?api_key=$apiKey&start=$start&end=$end";

// Initialise une requête cURL
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);              // URL à appeler
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);   // On veut récupérer la réponse
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);     // Timeout de connexion
curl_setopt($ch, CURLOPT_TIMEOUT, 20);            // Timeout total

$response = curl_exec($ch);

// Gère les erreurs cURL
if (curl_errno($ch)) {
    echo json_encode(['error' => 'cURL Error: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

curl_close($ch);

// Renvoyer la réponse brute de l’API au JavaScript (elle contient la distance)
echo $response;
