<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_profil
 *
 * @copyright   Copyright (C) 2025 Votre Nom. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\HTML\HTMLHelper;

// Inclure le fichier d'aide
require_once __DIR__ . '/helper.php';

// Récupérer l'ID du formulaire depuis la requête
$app = Factory::getApplication();
$input = $app->input;
$formId = $input->getInt('id', 0);
$submissionId = $input->getInt('submission_id', 0);

// Si aucun ID n'est fourni, sortir
if (!$formId && !$submissionId) {
    echo 'Aucun agriculteur spécifié. Veuillez utiliser ?id=XX ou ?submission_id=XX dans l\'URL.';
    return;
}

// Récupérer les données du profil de l'agriculteur
$helper = new ModAgriculteurProfilHelper();

if ($submissionId) {
    $profileData = $helper->getProfileDataBySubmissionId($submissionId);
} else {
    $profileData = $helper->getProfileDataByFormId($formId);
}

// Vérification de base pour $profileData
if (!isset($profileData) || $profileData === false) {
    echo 'Profil d\'agriculteur non trouvé.';
    return;
}

// Chargement des styles et scripts nécessaires
$document = Factory::getDocument();

// Chargement des styles CSS avec HTMLHelper
if ($params->get('load_mobile_css', 1)) {
    HTMLHelper::_('stylesheet', 'mod_agriculteur_profil/mobile.css', ['version' => 'auto', 'relative' => true]);
}

// Vérifier si on doit charger Bootstrap
if ($params->get('load_bootstrap', 1)) {
    HTMLHelper::_('stylesheet', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css');
    HTMLHelper::_('script', 'https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js');
}

// Vérifier si on doit charger Font Awesome
if ($params->get('load_fontawesome', 1)) {
    HTMLHelper::_('stylesheet', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css');
}

// Charger Fancybox pour la galerie d'images
HTMLHelper::_('stylesheet', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css');
HTMLHelper::_('script', 'https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js');
HTMLHelper::_('script', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js');

// Initialiser Fancybox
$document->addScriptDeclaration('
jQuery(document).ready(function($) {
    $("[data-fancybox]").fancybox({
        buttons: [
            "zoom",
            "slideShow",
            "fullScreen",
            "download",
            "close"
        ],
        loop: true
    });
    
    // Force les arrondis sur tous les éléments
    $(".profile-header, .profile-header-simple, .info-card").css({
        "border-radius": "10px",
        "overflow": "hidden"
    });
    
    // Force spécifiquement l\'arrondi sur la photo de couverture
    $(".cover-photo").css({
        "border-top-left-radius": "10px",
        "border-top-right-radius": "10px"
    });
    
    // Ne pas appliquer sur mobile
    if (window.innerWidth <= 767) {
        $(".profile-header, .profile-header-simple, .cover-photo").css("border-radius", "0");
    }
});
');

// Charger les styles spécifiques au module avec HTMLHelper
$cssFile = 'media/mod_agriculteur_profil/css/style.css';
if (file_exists(JPATH_SITE . '/' . $cssFile)) {
    HTMLHelper::_('stylesheet', $cssFile, ['version' => 'auto']);
}

// Ajouter les styles CSS personnalisés
$document->addStyleDeclaration('
/* Structure générale */
.content-wrapper {
    width: 100%;
    max-width: 100%;
    margin: 0 auto;
    padding: 0;
}

.content-container {
    width: 100%;
    max-width: 1140px;
    margin: 0 auto !important;
    padding: 0 !important;
}

/* Styles pour le header avec photo de couverture */
.profile-header, 
.profile-header-simple,
.info-card {
    position: relative;
    width: 100%;
    max-width: 1140px;
    margin: 0 auto 20px !important;
    border-radius: 10px !important;
    -webkit-border-radius: 10px !important;
    -moz-border-radius: 10px !important;
    overflow: hidden !important; /* Crucial pour que les arrondis fonctionnent */
}

/* Photo de couverture */
.cover-photo {
    width: 100%;
    height: auto;
    display: block;
    object-fit: contain;
    object-position: top;
    max-height: none;
    padding-top: 10px;
    border-top-left-radius: 10px !important;
    border-top-right-radius: 10px !important;
    -webkit-border-top-left-radius: 10px !important; 
    -webkit-border-top-right-radius: 10px !important;
    -moz-border-radius-topleft: 10px !important;
    -moz-border-radius-topright: 10px !important;
}

/* Conteneur des boutons */
.buttons-container {
    position: absolute;
    top: 50%;
    right: 15px;
    transform: translateY(-50%);
    z-index: 10;
    display: flex;
    flex-direction: column;
    gap: 10px;
}

.buttons-container-simple {
    display: flex;
    flex-direction: column;
    gap: 10px;
    margin-top: 15px;
}

/* Boutons */
.map-button {
    padding: 6px 12px;
    font-size: 0.9rem;
    font-weight: normal;
    z-index: 10;
}

/* Logo */
.logo-container {
    position: absolute;
    top: 50%;
    left: 20px;
    transform: translateY(-50%);
    z-index: 5;
}

.logo-container-simple {
    margin-bottom: 15px;
}

.logo-img {
    max-width: 120px;
    max-height: 120px;
    border-radius: 10px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
}

/* Overlay dégradé pour le bas de l\'image - atténué et limité à l\'image */
.header-content {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    padding: 20px;
    background: linear-gradient(to top, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0) 100px);
    color: white;
    padding-top: 50px;
    width: 100%;
}

.header-content-simple {
    margin-top: 15px;
}

/* Styles pour les titres - avec !important pour forcer la priorité */
.farm-title {
    font-size: 1.8rem !important;
    margin-bottom: 5px;
    text-shadow: 1px 1px 3px rgba(0, 0, 0, 0.7);
    max-width: 80%;
}

.section-title {
    color: var(--primary-color);
    margin-bottom: 15px;
    font-weight: 600;
    border-bottom: 2px solid var(--primary-color);
    padding-bottom: 8px;
    font-size: 1.5rem !important;
}

.info-card h3, 
.info-card .h5 {
    font-size: 1.2rem !important;
}

/* Styles pour les cartes d\'information */
.info-card {
    background-color: white;
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    padding: 20px;
    margin-bottom: 20px;
    margin-left: 0 !important;
    margin-right: 0 !important;
    width: 100%;
}

/* Ajustements pour gérer les textes longs */
.badge-container,
.product-list {
    width: 100%;
    word-wrap: break-word !important;
    overflow-wrap: break-word !important;
    display: flex;
    flex-wrap: wrap;
    gap: 8px;
    margin-top: 10px;
}

.category-badge {
    display: inline-block;
    background-color: var(--primary-color);
    color: white;
    border-radius: 4px;
    padding: 6px 12px;
    margin-right: 5px;
    margin-bottom: 10px;
    font-size: 0.9rem;
    font-weight: normal;
    word-wrap: break-word !important;
    white-space: normal !important;
    line-height: 1.5;
    text-align: left;
    max-width: 100%;
    hyphens: auto;
}

/* Styles pour les vidéos */
.video-container {
    position: relative;
    padding-bottom: 56.25%; /* Ratio 16:9 */
    height: 0;
    overflow: hidden;
    margin-bottom: 15px;
}

.video-container iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
}

/* Styles pour les produits de la semaine */
.products-week {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border-left: 4px solid var(--primary-color);
    margin-bottom: 20px;
}

/* Espacement entre les colonnes en mode grand écran */
@media (min-width: 768px) {
    .container {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }
    
    .row {
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    .col-md-4, .col-md-6 {
        padding-left: 10px !important;
        padding-right: 10px !important;
    }
}

/* Responsive adjustments avec spécificité accrue */
@media (max-width: 767px) {
    .profile-header,
    .profile-header-simple {
        margin: 0 0 20px !important;
        border-radius: 0 !important;
        -webkit-border-radius: 0 !important;
        -moz-border-radius: 0 !important;
    }
    
    .cover-photo {
        padding-top: 0;
        border-radius: 0 !important;
        -webkit-border-radius: 0 !important;
        -moz-border-radius: 0 !important;
    }
    
    .header-content {
        background: linear-gradient(to top, rgba(0, 0, 0, 0.5) 0%, rgba(0, 0, 0, 0) 80px);
    }
    
    .logo-img {
        max-width: 80px;
        max-height: 80px;
    }
    
    .profile-header .farm-title,
    .profile-header-simple .farm-title {
        font-size: 1.5rem !important;
    }
    
    .info-card .section-title {
        font-size: 1.2rem !important;
    }
    
    .info-card h3,
    .info-card .h5 {
        font-size: 1.1rem !important;
    }
    
    /* Réduire la taille des boutons sur mobile */
    .map-button, 
    .btn-sm {
        padding: 4px 8px !important;
        font-size: 0.8rem !important;
        line-height: 1.2 !important;
    }
    
    .buttons-container,
    .buttons-container-simple {
        gap: 5px;
    }
    
    .fa-map-marker-alt,
    .fa-arrow-left {
        font-size: 0.8rem !important;
    }
    
    .me-1 {
        margin-right: 0.15rem !important;
    }
    
    /* Correction des marges */
    .content-container {
        padding: 0 !important;
    }
    
    .info-card {
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
}

/* Écrans moyens */
@media (min-width: 768px) and (max-width: 991px) {
    .profile-header .farm-title,
    .profile-header-simple .farm-title {
        font-size: 1.7rem !important;
    }
    
    .info-card .section-title {
        font-size: 1.3rem !important;
    }
}

/* Écrans larges */
@media (min-width: 992px) and (max-width: 1199px) {
    .profile-header .farm-title,
    .profile-header-simple .farm-title {
        font-size: 1.9rem !important;
    }
    
    .info-card .section-title {
        font-size: 1.4rem !important;
    }
}

/* Grands écrans */
@media (min-width: 1200px) and (max-width: 1599px) {
    .profile-header .farm-title,
    .profile-header-simple .farm-title {
        font-size: 2.2rem !important;
    }
    
    .info-card .section-title {
        font-size: 1.6rem !important;
    }
    
    .info-card h3,
    .info-card .h5 {
        font-size: 1.3rem !important;
    }
}

/* Très grands écrans */
@media (min-width: 1600px) {
    .profile-header .farm-title,
    .profile-header-simple .farm-title {
        font-size: 2.5rem !important;
    }
    
    .content-container {
        max-width: 1400px !important;
    }
    
    .profile-header,
    .profile-header-simple,
    .info-card {
        max-width: 1400px !important;
        margin-top: 0;
    }
}

/* Surcharges supplémentaires */
main.container-fluid {
    padding-left: 0 !important;
    padding-right: 0 !important;
}

.row > * {
    padding-right: calc(var(--bs-gutter-x) * .4) !important;
    padding-left: calc(var(--bs-gutter-x) * .4) !important;
}
');

// Personnaliser les couleurs selon les paramètres
$customCSS = '
:root {
    --primary-color: ' . $params->get('primary_color', '#3c8f44') . ';
    --accent-color: ' . $params->get('accent_color', '#e67e22') . ';
}

/* Surcharge Bootstrap pour empêcher les titres trop grands */
h1, .h1 { font-size: calc(1.3rem + 0.9vw) !important; }
h2, .h2 { font-size: calc(1.275rem + 0.3vw) !important; }
h3, .h3 { font-size: 1.25rem !important; }

/* Surcharge pour les boutons */
.btn-sm {
    font-size: 0.875rem !important;
    padding: 0.25rem 0.5rem !important;
    line-height: 1.5 !important;
}
';
$document->addStyleDeclaration($customCSS);

// Inclure le template d'affichage
require ModuleHelper::getLayoutPath('mod_agriculteur_profil', $params->get('layout', 'default'));