<?php
/**
 * Test rapide - Résolution CORS OpenRouteService
 * Créez ce fichier : /modules/mod_agriculteur_liste/test-no-cors.php
 * Accédez à : votre-site.com/modules/mod_agriculteur_liste/test-no-cors.php
 */

header('Content-Type: text/html; charset=utf-8');

// CONFIGUREZ VOTRE CLÉ ICI ⬇️
$apiKey = '5b3ce3597851110001cf62480c7ae4d074084cd6aefd8f3652182e26'; // ← Remplacez

// Test route Saint-Denis → Saint-Pierre
$coordinates = [
    [55.4504, -20.8823], // Saint-Denis [lon, lat]
    [55.4781, -21.3393]  // Saint-Pierre [lon, lat]
];

?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>🧪 Test Anti-CORS OpenRouteService</title>
    <style>
        body { font-family: Arial, sans-serif; max-width: 800px; margin: 20px auto; padding: 20px; }
        .test-card { background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 8px; padding: 20px; margin: 15px 0; }
        .success { background: #d4edda; border-color: #c3e6cb; }
        .error { background: #f8d7da; border-color: #f5c6cb; }
        .loading { background: #fff3cd; border-color: #ffeaa7; }
        button { background: #007bff; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; margin: 5px; }
        button:disabled { background: #6c757d; cursor: not-allowed; }
        pre { background: #f1f3f4; padding: 10px; border-radius: 5px; overflow-x: auto; }
    </style>
</head>
<body>
    <h1>🧪 Test Anti-CORS OpenRouteService</h1>
    
    <div class="test-card">
        <h3>🎯 Objectif</h3>
        <p>Prouver que <strong>PHP côté serveur</strong> résout le problème CORS</p>
        <ul>
            <li>✅ PHP fait l'appel ORS (pas de CORS)</li>
            <li>✅ JavaScript appelle PHP (même domaine)</li>
            <li>❌ Plus d'appel direct navigateur → ORS</li>
        </ul>
    </div>

    <?php if ($apiKey === '5b3ce3597851110001cf62480c7ae4d074084cd6aefd8f3652182e26'): ?>
    <div class="test-card error">
        <h3>⚠️ Configuration requise</h3>
        <p>Remplacez la variable <code>$apiKey</code> par votre vraie clé OpenRouteService</p>
    </div>
    <?php else: ?>
    
    <button onclick="testPhpBackend()">🧪 Test 1: PHP Backend (sans CORS)</button>
    <button onclick="testDirectORS()">❌ Test 2: Direct ORS (avec CORS)</button>
    <button onclick="testComparison()">🔄 Test 3: Comparaison</button>
    
    <div id="results"></div>
    
    <?php endif; ?>

    <script>
        // Test 1: Appel via PHP (MA SOLUTION - pas de CORS)
        async function testPhpBackend() {
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = `
                <div class="test-card loading">
                    <h3>🧪 Test PHP Backend</h3>
                    <p>Appel via serveur PHP... (pas de CORS)</p>
                </div>
            `;
            
            try {
                const response = await fetch(window.location.href.replace('test-no-cors.php', '') + 'api/get-distance.php?start=55.4504,-20.8823&end=55.4781,-21.3393&fallback=1');
                
                if (response.ok) {
                    const data = await response.json();
                    resultsDiv.innerHTML = `
                        <div class="test-card success">
                            <h3>✅ PHP Backend - SUCCÈS</h3>
                            <p><strong>Aucun problème CORS !</strong></p>
                            <pre>${JSON.stringify(data, null, 2)}</pre>
                            <p>🎉 Distance calculée: <strong>${data.distance?.road_km || 'N/A'} km</strong></p>
                        </div>
                    `;
                } else {
                    throw new Error(`HTTP ${response.status}`);
                }
            } catch (error) {
                resultsDiv.innerHTML = `
                    <div class="test-card error">
                        <h3>❌ Erreur PHP Backend</h3>
                        <p>Erreur: ${error.message}</p>
                        <p>Vérifiez que le fichier get-distance.php existe et est configuré</p>
                    </div>
                `;
            }
        }
        
        // Test 2: Appel direct ORS (ANCIEN CODE - avec CORS)
        async function testDirectORS() {
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = `
                <div class="test-card loading">
                    <h3>❌ Test Direct ORS</h3>
                    <p>Appel direct depuis navigateur... (va échouer CORS)</p>
                </div>
            `;
            
            try {
                const response = await fetch('https://api.openrouteservice.org/v2/directions/driving-car', {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'Authorization': '<?php echo $apiKey; ?>',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        coordinates: <?php echo json_encode($coordinates); ?>,
                        format: 'json'
                    })
                });
                
                // Si on arrive ici, c'est surprenant !
                const data = await response.json();
                resultsDiv.innerHTML = `
                    <div class="test-card success">
                        <h3>😮 Direct ORS - Succès inattendu</h3>
                        <p>Le CORS a fonctionné (rare !)</p>
                        <pre>${JSON.stringify(data, null, 2)}</pre>
                    </div>
                `;
                
            } catch (error) {
                resultsDiv.innerHTML = `
                    <div class="test-card error">
                        <h3>❌ Direct ORS - Échec CORS (normal)</h3>
                        <p><strong>Erreur CORS :</strong> ${error.message}</p>
                        <p>🎯 <strong>C'est exactement votre problème actuel !</strong></p>
                        <p>💡 <strong>Solution :</strong> Utilisez le PHP Backend (Test 1)</p>
                    </div>
                `;
            }
        }
        
        // Test 3: Comparaison des deux approches
        async function testComparison() {
            const resultsDiv = document.getElementById('results');
            resultsDiv.innerHTML = `
                <div class="test-card loading">
                    <h3>🔄 Comparaison des approches</h3>
                    <p>Test simultané...</p>
                </div>
            `;
            
            const results = await Promise.allSettled([
                // Test PHP
                fetch(window.location.href.replace('test-no-cors.php', '') + 'api/get-distance.php?start=55.4504,-20.8823&end=55.4781,-21.3393&fallback=1')
                    .then(r => r.ok ? r.json() : Promise.reject(new Error('PHP failed'))),
                
                // Test direct ORS
                fetch('https://api.openrouteservice.org/v2/directions/driving-car', {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'Authorization': '<?php echo $apiKey; ?>',
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        coordinates: <?php echo json_encode($coordinates); ?>,
                        format: 'json'
                    })
                }).then(r => r.ok ? r.json() : Promise.reject(new Error('CORS failed')))
            ]);
            
            const phpResult = results[0];
            const corsResult = results[1];
            
            resultsDiv.innerHTML = `
                <div class="test-card">
                    <h3>📊 Comparaison des résultats</h3>
                    
                    <h4>🟢 PHP Backend (ma solution)</h4>
                    <p><strong>Status:</strong> ${phpResult.status === 'fulfilled' ? '✅ Succès' : '❌ Échec'}</p>
                    ${phpResult.status === 'fulfilled' ? 
                        `<p><strong>Distance:</strong> ${phpResult.value.distance?.road_km || 'N/A'} km</p>` :
                        `<p><strong>Erreur:</strong> ${phpResult.reason}</p>`
                    }
                    
                    <h4>🔴 Direct ORS (ancien code)</h4>
                    <p><strong>Status:</strong> ${corsResult.status === 'fulfilled' ? '✅ Succès (rare)' : '❌ Échec CORS (normal)'}</p>
                    ${corsResult.status === 'fulfilled' ? 
                        `<p><strong>Distance:</strong> ${(corsResult.value.routes?.[0]?.summary?.distance / 1000 || 'N/A')} km</p>` :
                        `<p><strong>Erreur:</strong> CORS bloqué</p>`
                    }
                    
                    <div style="background: #e7f3ff; padding: 15px; border-radius: 5px; margin-top: 15px;">
                        <strong>🎯 Conclusion:</strong><br>
                        ${phpResult.status === 'fulfilled' && corsResult.status === 'rejected' ? 
                            '✅ PHP Backend fonctionne, Direct ORS échoue → Utilisez ma solution !' :
                            phpResult.status === 'fulfilled' ? 
                                '✅ PHP Backend fonctionne → Recommandé pour la fiabilité' :
                                '❌ Problème de configuration → Vérifiez votre setup'
                        }
                    </div>
                </div>
            `;
        }
    </script>
</body>
</html>