
document.addEventListener('DOMContentLoaded', function () {
    const mapContainer = document.getElementById('map');
    if (!mapContainer) return;

    const map = L.map('map').setView([-21.115141, 55.536384], 10);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    navigator.geolocation.getCurrentPosition(function (position) {
        const userLatLng = [position.coords.latitude, position.coords.longitude];
        L.marker(userLatLng).addTo(map).bindPopup('Vous êtes ici').openPopup();
        map.setView(userLatLng, 13);
    });

    document.querySelectorAll('.agriculteur').forEach(function (el) {
        const lat = el.dataset.lat;
        const lng = el.dataset.lng;
        const nom = el.dataset.nom;

        if (lat && lng) {
            L.marker([lat, lng]).addTo(map).bindPopup(nom);
        }
    });
});
