<?php
/**
 * @package RSForm!Pro
 * @copyright (C) 2007-2019 www.rsjoomla.com
 * @license GPL, http://www.gnu.org/copyleft/gpl.html
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class RSFormProPassword
{
	protected $passwordField;
	protected $userOptions;
	protected $layout;
	protected $formId;

	static $configSet = false;
	static $init = false;

	public function __construct($formId) {
		$this->formId = $formId;

		// get and set the global user parameters
		$usersparams = RSFormProPassword::getUsersParams();
		$this->userOptions = array();
		$this->userOptions['minLength']    = $usersparams->get('minimum_length');
		$this->userOptions['minIntegers']  = $usersparams->get('minimum_integers');
		$this->userOptions['minSymbols']   = $usersparams->get('minimum_symbols');
		$this->userOptions['minUppercase'] = $usersparams->get('minimum_uppercase');
		$this->userOptions['minLowercase'] = $usersparams->get('minimum_lowercase', 0);

		$this->setConfig();
	}

	public static function getInstance($formId) {
		static $instances = array();
		if (!isset($instances[$formId])) {
			$instances[$formId] = new RSFormProPassword($formId);
		}

		return $instances[$formId];
	}

	public static function getUsersParams() {
		static $params;
		if (is_null($params)) {
			$params = JComponentHelper::getParams('com_users');
		}

		return $params;
	}

	public function setConfig() {
		if (!RSFormProPassword::$configSet) {
			RSFormProAssets::addScript(JHtml::_('script', 'plg_system_rsfpregistration/password-strength.js', array('relative' => true, 'version' => 'auto', 'pathOnly' => true)));
			RSFormProAssets::addStyleSheet(JHtml::_('stylesheet', 'plg_system_rsfpregistration/password-strength.css', array('relative' => true, 'version' => 'auto', 'pathOnly' => true)));

			RSFormProAssets::addScriptDeclaration('RSFormProPasswords.translations = ' . json_encode(array('RSFP_REG_BE_AT_LEAST_CHARACTERS' => JText::_('RSFP_REG_BE_AT_LEAST_CHARACTERS'), 'RSFP_REG_TYPE_MORE_CHARACTERS' => JText::_('RSFP_REG_TYPE_MORE_CHARACTERS'), 'RSFP_REG_NEEDS_NUMBERS' => JText::_('RSFP_REG_NEEDS_NUMBERS'), 'RSFP_REG_HAS_AT_LEAST_NUMBERS' => JText::_('RSFP_REG_HAS_AT_LEAST_NUMBERS'), 'RSFP_REG_TYPE_MORE_NUMBERS' => JText::_('RSFP_REG_TYPE_MORE_NUMBERS'), 'RSFP_REG_NEEDS_SYMBOLS' => JText::_('RSFP_REG_NEEDS_SYMBOLS'), 'RSFP_REG_HAS_AT_LEAST_SYMBOLS' => JText::_('RSFP_REG_HAS_AT_LEAST_SYMBOLS'), 'RSFP_REG_TYPE_MORE_SYMBOLS' => JText::_('RSFP_REG_TYPE_MORE_SYMBOLS'), 'RSFP_REG_NEEDS_UPPERCASE_LETTERS' => JText::_('RSFP_REG_NEEDS_UPPERCASE_LETTERS'), 'RSFP_REG_HAS_AT_LEAST_UPPERCASE_LETTERS' => JText::_('RSFP_REG_HAS_AT_LEAST_UPPERCASE_LETTERS'), 'RSFP_REG_TYPE_MORE_UPPERCASE_LETTERS' => JText::_('RSFP_REG_TYPE_MORE_UPPERCASE_LETTERS'), 'RSFP_REG_NEEDS_LOWERCASE_LETTERS' => JText::_('RSFP_REG_NEEDS_LOWERCASE_LETTERS'),'RSFP_REG_HAS_AT_LEAST_LOWERCASE_LETTERS' => JText::_('RSFP_REG_HAS_AT_LEAST_LOWERCASE_LETTERS'), 'RSFP_REG_TYPE_MORE_LOWERCASE_LETTERS' => JText::_('RSFP_REG_TYPE_MORE_LOWERCASE_LETTERS'))));

			// all password fields from all the forms uses these user options, so we load them here
			$userOptionsScript = 'RSFormProPasswords.userOptions = '.json_encode($this->userOptions) . ';';
			RSFormProAssets::addScriptDeclaration($userOptionsScript);
			RSFormProPassword::$configSet = true;
		}
	}

	public function setLayout($layout) {
		$this->layout = $layout;

		if ($layout === 'uikit3')
		{
			RSFormProAssets::addStyleSheet(JHtml::_('stylesheet', 'plg_system_rsfpregistration/uikit3-progress.css', array('relative' => true, 'version' => 'auto', 'pathOnly' => true)));
		}
	}

	public function setPasswordField($field) {
		$this->passwordField = $field;
	}

	public function printInlineScript() {
		$script = '';
		if (!empty($this->passwordField) && !is_null($this->layout)) {
			$props = array(
				'layout' => $this->layout,
				'formId' => $this->formId,
				'field'  => $this->passwordField
			);
			$script .= 'RSFormProPasswords.addForm('.json_encode($props).');';

			// we need to load this just once regardless of the instance
			if (!RSFormProPassword::$init) {
				$script .= "\n";
				$script .= "window.addEventListener('DOMContentLoaded', function() {
					RSFormProPasswords.init();
				});";

				RSFormProPassword::$init = true;
			}
		}

		return $script;
	}
}