<?php
// Activer les erreurs pour le debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Définir l'accès à Joomla
define('_JEXEC', 1);
require_once __DIR__ . '/../configuration.php';
require_once JPATH_BASE . '/includes/defines.php';
require_once __DIR__ . '/../includes/framework.php';

// Initialiser Joomla
$app = JFactory::getApplication('site');
$db = JFactory::getDbo();

// Requête pour récupérer les soumissions valides
$query = $db->getQuery(true)
    ->select('s.SubmissionId, e.FieldValue AS email, t.FieldValue AS token')
    ->from('#__rsform_submissions AS s')
    ->join('INNER', '#__rsform_submission_values AS e ON s.SubmissionId = e.SubmissionId AND e.FieldName = "email"')
    ->join('INNER', '#__rsform_submission_values AS t ON s.SubmissionId = t.SubmissionId AND t.FieldName = "token"')
    ->join('INNER', '#__rsform_submission_values AS i ON s.SubmissionId = i.SubmissionId AND i.FieldName = "inscription"')
    ->where('s.FormId = 8')
    ->where('i.FieldValue IN ("25€/mois","35€/mois","45€/mois")')
    ->group('s.SubmissionId');

$db->setQuery($query);
$submissions = $db->loadObjectList();

// Vérifier si des soumissions existent
if (empty($submissions)) {
    error_log("🚨 CRON : Aucune soumission trouvée pour l'envoi d'email.");
    exit;
}

// Initialiser l'email
$mailer = JFactory::getMailer();
$config = JFactory::getConfig();
$sender = ['contact@labiolela.re', 'Labioléla'];
$mailer->setSender($sender);
$mailer->setSubject('Lien pour modification hebdomadaire');

// Parcourir chaque soumission et envoyer l'email
foreach ($submissions as $sub) {
    $link = 'https://labiolela.re/custom/edition_partielle.php&submission=' . $sub->SubmissionId . '&token=' . $sub->token;

    $mailer->addRecipient($sub->email);
    $mailer->setBody("Bonjour,\n\nVoici votre lien sécurisé pour modifier vos informations cette semaine :\n\n" . $link . "\n\nCordialement,\nL'équipe  La Bioléla");

    // Vérifier si l'envoi réussit
    if ($mailer->send()) {
        error_log("✅ Email envoyé avec succès à " . $sub->email);
    } else {
        error_log("❌ Échec de l'envoi à " . $sub->email);
    }

    // Nettoyer les destinataires avant le prochain envoi
    $mailer->clearAllRecipients();
}

error_log("🎉 CRON terminé avec succès !");
?>
