<?php
session_start(); // Démarrer la session pour stocker l'état de mise à jour
ob_start();      // Commencer la mise en tampon pour éviter le "headers already sent"

// Activer les erreurs pour le debug
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Charger la configuration Joomla
define('_JEXEC', 1);
require_once $_SERVER['DOCUMENT_ROOT'] . '/configuration.php';

// Connexion à la base de données Joomla
$joomlaConfig = new JConfig();
$database = new mysqli($joomlaConfig->host, $joomlaConfig->user, $joomlaConfig->password, $joomlaConfig->db);
if ($database->connect_error) {
    die("⛔ Connexion échouée : " . $database->connect_error);
}

// Définir le préfixe Joomla
$dbprefix = "wqkom_"; 

// Récupération des paramètres
$submissionId = isset($_GET['submission']) ? (int) $_GET['submission'] : 0;
$token = isset($_GET['token']) ? $_GET['token'] : '';

if (!$submissionId || empty($token)) {
    die('<p style="color:red;">⛔ ERREUR : Lien invalide.</p>');
}

// Vérification du token
$query = "SELECT COUNT(*) FROM " . $dbprefix . "rsform_submission_values 
          WHERE SubmissionId = ? 
            AND FieldName = 'token' 
            AND FieldValue = ?";
$stmt = $database->prepare($query);
$stmt->bind_param("is", $submissionId, $token);
$stmt->execute();
$stmt->bind_result($valid);
$stmt->fetch();
$stmt->close();

if (!$valid) {
    die('<p style="color:red;">⛔ ERREUR : Token invalide.</p>');
}

// Récupération des valeurs soumises
$query = "SELECT FieldName, FieldValue FROM " . $dbprefix . "rsform_submission_values 
          WHERE SubmissionId = ?";
$stmt = $database->prepare($query);
$stmt->bind_param("i", $submissionId);
$stmt->execute();
$result = $stmt->get_result();
$formData = [];
while ($row = $result->fetch_assoc()) {
    $formData[$row['FieldName']] = $row['FieldValue'];
}
$stmt->close();

// Vérification des valeurs récupérées
$nom = isset($formData['nom']) ? htmlspecialchars($formData['nom']) : 'AUCUN NOM';
$prenom = isset($formData['prenom']) ? htmlspecialchars($formData['prenom']) : 'AUCUN PRÉNOM';
$joursReception = isset($formData['jours-reception']) ? explode(',', $formData['jours-reception']) : [];
$produitsSemaine = isset($formData['produits-semaine']) ? htmlspecialchars($formData['produits-semaine']) : '';
$horairesReception = isset($formData['horaires-reception']) ? htmlspecialchars($formData['horaires-reception']) : '';

// Répartition des jours en 2 lignes
$joursLigne1 = ['Lundi', 'Mardi', 'Mercredi', 'Jeudi'];
$joursLigne2 = ['Vendredi', 'Samedi', 'Dimanche'];

// Si le formulaire est soumis, mettre à jour
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $joursReceptionPosted = isset($_POST['jours-reception']) ? implode(',', $_POST['jours-reception']) : '';
    $produitsSemainePosted = $_POST['produits-semaine'] ?? '';
    $horairesReceptionPosted = $_POST['horaires-reception'] ?? '';

    foreach ([
        'jours-reception' => $joursReceptionPosted,
        'produits-semaine' => $produitsSemainePosted,
        'horaires-reception' => $horairesReceptionPosted
    ] as $field => $value) {
        $updateQuery = "UPDATE " . $dbprefix . "rsform_submission_values 
                        SET FieldValue = ? 
                        WHERE SubmissionId = ? 
                          AND FieldName = ?";
        $stmt = $database->prepare($updateQuery);
        $stmt->bind_param("sis", $value, $submissionId, $field);
        $stmt->execute();
        $stmt->close();
    }

    // Mise à jour réussie
    $_SESSION['update_success'] = true;
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit();
}

// On ferme la connexion avant d'envoyer le HTML
$database->close();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mise à jour des informations</title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }
        
        body { 
            font-family: Arial, sans-serif;
            background: #f9f9f9;
            padding: 10px;
            width: 100%;
            min-height: 100vh;
        }
        
        .container {
            width: 100%;
            max-width: 600px;
            background: white;
            padding: 15px;
            border-radius: 10px;
            box-shadow: 0px 0px 10px rgba(0,0,0,0.1);
            margin: 0 auto;
            text-align: center;
        }
        
        h2 { 
            color: #333; 
            font-size: 1.5rem;
            margin-bottom: 10px;
        }
        
        p { 
            margin-bottom: 15px; 
            font-size: 0.95rem;
        }
        
        .section-title { 
            font-weight: bold; 
            display: block; 
            margin-top: 15px;
            text-align: center;
            font-size: 1rem;
            margin-bottom: 8px;
        }
        
        input[type='text'], textarea {
            width: 100%; 
            padding: 10px; 
            margin-top: 5px; 
            border: 1px solid #ddd; 
            border-radius: 5px;
        }
        
        textarea { 
            height: 100px; 
            resize: vertical;
        }
        
        .jours-reception { 
            display: flex; 
            flex-direction: column; 
            align-items: center;
            margin: 10px 0;
            width: 100%;
        }
        
        .jours-ligne {
            display: flex; 
            justify-content: center;
            flex-wrap: wrap;
            gap: 10px;
            margin-bottom: 5px;
            width: 100%;
        }
        
        .jour-option {
            display: flex;
            align-items: center;
            margin-right: 5px;
        }
        
        .jour-option input {
            margin-right: 5px;
        }
        
        .success-message { 
            color: green; 
            font-weight: bold; 
            margin: 10px auto; 
            padding: 10px;
            background-color: #e8f5e9;
            border: 1px solid #c8e6c9;
            border-radius: 5px;
            display: none; /* Caché par défaut */
        }
        
        button { 
            width: 100%; 
            background: #28a745; 
            color: white; 
            padding: 12px 15px; 
            border: none; 
            border-radius: 5px; 
            cursor: pointer; 
            margin-top: 20px; 
            font-size: 16px; 
        }
        
        button:hover { 
            background: #218838; 
        }
        
        @media (max-width: 480px) {
            body {
                padding: 0;
            }
            
            .container {
                border-radius: 0;
                min-height: 100vh;
                padding: 15px 10px;
                box-shadow: none;
            }
            
            h2 {
                font-size: 1.3rem;
            }
            
            .jour-option {
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Bonjour <strong><?= $nom ?> <?= $prenom ?></strong></h2>
        <p>Indiquez les produits disponibles cette semaine<br>et modifiez vos heures de réception :</p>

        <!-- Message de confirmation -->
        <div class="success-message" id="success-msg">✅ Données mises à jour avec succès.</div>

        <!-- Formulaire de modification -->
        <form method="POST">
            <div class="section-title">Jours de réception :</div>
            <div class="jours-reception">
                <div class="jours-ligne">
                    <?php foreach ($joursLigne1 as $jour) : ?>
                        <div class="jour-option">
                            <input type="checkbox" id="<?= strtolower($jour); ?>" name="jours-reception[]" value="<?= $jour; ?>"
                                   <?= in_array($jour, $joursReception) ? 'checked' : ''; ?>>
                            <label for="<?= strtolower($jour); ?>"><?= $jour; ?></label>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="jours-ligne">
                    <?php foreach ($joursLigne2 as $jour) : ?>
                        <div class="jour-option">
                            <input type="checkbox" id="<?= strtolower($jour); ?>" name="jours-reception[]" value="<?= $jour; ?>"
                                   <?= in_array($jour, $joursReception) ? 'checked' : ''; ?>>
                            <label for="<?= strtolower($jour); ?>"><?= $jour; ?></label>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="section-title">Produits disponibles cette semaine :</div>
            <textarea id="produits-semaine" name="produits-semaine"><?= $produitsSemaine; ?></textarea>

            <div class="section-title">Horaires de réception :</div>
            <textarea id="horaires-reception" name="horaires-reception"><?= $horairesReception; ?></textarea>

            <button type="submit" name="submit">✅ Enregistrer les modifications</button>
        </form>
    </div>

    <!-- Script pour gérer l'affichage du message de confirmation -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php if (isset($_SESSION['update_success']) && $_SESSION['update_success']) : ?>
                // Afficher le message de confirmation
                var successMsg = document.getElementById('success-msg');
                successMsg.style.display = 'block';
                
                // Masquer le message après 3 secondes
                setTimeout(function() {
                    successMsg.style.opacity = '0';
                    successMsg.style.transition = 'opacity 1s';
                    setTimeout(function() {
                        successMsg.style.display = 'none';
                    }, 1000);
                }, 3000);
                
                // S'assurer que la page est en haut
                window.scrollTo(0, 0);

                // Réinitialiser le flag après avoir affiché le message
                <?php $_SESSION['update_success'] = false; ?>
            <?php endif; ?>
        });
    </script>
</body>
</html>

<?php
// Traitement de la sauvegarde
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $joursReception = isset($_POST['jours-reception']) ? implode(',', $_POST['jours-reception']) : '';
    $produitsSemaine = isset($_POST['produits-semaine']) ? $_POST['produits-semaine'] : '';
    $horairesReception = isset($_POST['horaires-reception']) ? $_POST['horaires-reception'] : '';

    foreach ([
        'jours-reception' => $joursReception,
        'produits-semaine' => $produitsSemaine,
        'horaires-reception' => $horairesReception
    ] as $field => $value) {
        $query = "UPDATE " . $dbprefix . "rsform_submission_values SET FieldValue = ? WHERE SubmissionId = ? AND FieldName = ?";
        $stmt = $database->prepare($query);
        $stmt->bind_param("sis", $value, $submissionId, $field);
        $stmt->execute();
        $stmt->close();
    }

    $_SESSION['update_success'] = true;
    header("Location: " . $_SERVER['REQUEST_URI']);
    exit();
}

ob_end_flush(); // Fin de la mise en tampon, envoi du HTML
?>
