window.addEventListener('DOMContentLoaded', function(){
	var modals = document.querySelectorAll('.rsform-simple-js-modal');
	var triggers = document.querySelectorAll('.rsform-simple-js-modal-trigger');
	var closeButtons = document.querySelectorAll('.rsform-simple-js-modal-close-button');

	if (modals.length > 0) {
		var modal, trigger, closeButton;
		for (var i = 0; i < modals.length; i++) {
			modal = modals[i];
			trigger = triggers[i];
			closeButton = closeButtons[i];

			(function (modal, trigger, closeButton, window) {
				function toggleModal() {
					modal.classList.toggle('rsform-simple-js-modal-show-modal');
					document.body.classList.toggle('rsform-simple-js-modal-open-modal')
				}

				function windowOnClick(event) {
					if (event.target === modal) {
						toggleModal();
					}
				}

				trigger.addEventListener('click', toggleModal);
				closeButton.addEventListener('click', toggleModal);
				window.addEventListener('click', windowOnClick);

				if (modal.classList.contains('rsform-simple-js-modal-show-modal')) {
					document.body.classList.add('rsform-simple-js-modal-open-modal')
				}
			}(modal, trigger, closeButton, window));
		}
	}
});