<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_liste
 *
 * @copyright   (C) 2023 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;

// Récupération des paramètres
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx', ''));
$layout = $params->get('layout', 'default');
$items = $list;

// Chargement du CSS
$document = Factory::getDocument();
$document->addStyleSheet(Uri::base(true) . '/modules/mod_agriculteur_liste/tmpl/default.css');

// Chargement du script pour la géolocalisation
$js = <<<JS
document.addEventListener('DOMContentLoaded', function() {
    // Fonction pour obtenir la position actuelle de l'utilisateur
    function getUserLocation() {
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;
                    
                    // Vérifier si la position est dans les limites de La Réunion
                    if (isInReunionBounds(lat, lng)) {
                        // Stocker la position dans des cookies
                        document.cookie = "user_lat=" + lat + "; path=/; max-age=86400";
                        document.cookie = "user_lng=" + lng + "; path=/; max-age=86400";
                        
                        // Recharger la page pour mettre à jour les distances
                        window.location.reload();
                    } else {
                        alert("Votre position actuelle n'est pas sur l'île de la Réunion.");
                    }
                },
                function(error) {
                    let errorMessage;
                    switch(error.code) {
                        case error.PERMISSION_DENIED:
                            errorMessage = "L'accès à la géolocalisation a été refusé.";
                            break;
                        case error.POSITION_UNAVAILABLE:
                            errorMessage = "Les informations de localisation ne sont pas disponibles.";
                            break;
                        case error.TIMEOUT:
                            errorMessage = "La demande de géolocalisation a expiré.";
                            break;
                        default:
                            errorMessage = "Une erreur inconnue s'est produite lors de la géolocalisation.";
                    }
                    alert(errorMessage);
                }
            );
        } else {
            alert("La géolocalisation n'est pas prise en charge par votre navigateur.");
        }
    }
    
    // Vérifier si les coordonnées sont dans les limites de La Réunion
    function isInReunionBounds(lat, lng) {
        // Limites approximatives de La Réunion
        const REUNION_BOUNDS = {
            minLat: -21.4, maxLat: -20.8,
            minLng: 55.2, maxLng: 55.9
        };
        
        return (
            lat >= REUNION_BOUNDS.minLat && lat <= REUNION_BOUNDS.maxLat &&
            lng >= REUNION_BOUNDS.minLng && lng <= REUNION_BOUNDS.maxLng
        );
    }
    
    // Ajouter un écouteur d'événement au bouton de géolocalisation
    var geolocBtn = document.getElementById('geoloc-btn');
    if (geolocBtn) {
        geolocBtn.addEventListener('click', getUserLocation);
    }
});
JS;

$document->addScriptDeclaration($js);
?>

<div class="agriculteur-liste<?php echo $moduleclass_sfx; ?>">
    <div class="geoloc-container">
        <button id="geoloc-btn" class="btn btn-primary btn-sm">
            <span class="icon-location" aria-hidden="true"></span> Utiliser ma position
        </button>
        
        <?php if ($userLat && $userLng): ?>
        <div class="user-position">
            Position actuelle: <span class="coordinates"><?php echo round($userLat, 4); ?>, <?php echo round($userLng, 4); ?></span>
        </div>
        <?php endif; ?>
    </div>
    
    <?php if (!empty($items)) : ?>
        <div class="items">
            <?php foreach ($items as $item) : ?>
                <?php
                // Récupération des coordonnées de l'agriculteur
                $agriLat = isset($item->custom_fields['latitude']) ? (float) $item->custom_fields['latitude']->value : 0;
                $agriLng = isset($item->custom_fields['longitude']) ? (float) $item->custom_fields['longitude']->value : 0;
                
                // Calcul de la distance routière
                $routeInfo = ModAgriculteurListeHelper::calculateRouteDistance($userLat, $userLng, $agriLat, $agriLng);
                $distance = $routeInfo['distance'];
                $duration = ModAgriculteurListeHelper::formatDuration($routeInfo['duration']);
                
                // Récupération des autres champs personnalisés
                $adresse = isset($item->custom_fields['adresse']) ? $item->custom_fields['adresse']->value : '';
                $telephone = isset($item->custom_fields['telephone']) ? $item->custom_fields['telephone']->value : '';
                $email = isset($item->custom_fields['email']) ? $item->custom_fields['email']->value : '';
                $site_web = isset($item->custom_fields['site_web']) ? $item->custom_fields['site_web']->value : '';
                
                // Récupération de l'image
                $images = json_decode($item->images);
                $image = '';
                if (!empty($images->image_intro)) {
                    $image = HTMLHelper::_('cleanImageURL', $images->image_intro)->url;
                }
                
                // Récupération des données RSForm si disponibles
                $rsformData = !empty($item->rsform_data) ? $item->rsform_data[0] : null;
                ?>
                
                <div class="agriculteur-item">
                    <?php if ($image) : ?>
                        <div class="agriculteur-image">
                            <img src="<?php echo $image; ?>" alt="<?php echo htmlspecialchars($item->title); ?>">
                        </div>
                    <?php endif; ?>
                    
                    <div class="agriculteur-content">
                        <h2 class="agriculteur-title">
                            <a href="<?php echo $item->link; ?>"><?php echo $item->title; ?></a>
                        </h2>
                        
                        <?php if ($adresse) : ?>
                            <div class="agriculteur-adresse">
                                <span class="icon-home" aria-hidden="true"></span> <?php echo $adresse; ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="agriculteur-distance">
                            <span class="icon-location" aria-hidden="true"></span> 
                            Distance: <strong><?php echo $distance; ?> km</strong> (<?php echo $duration; ?> en voiture)
                        </div>
                        
                        <div class="agriculteur-contact">
                            <?php if ($telephone) : ?>
                                <div class="agriculteur-telephone">
                                    <span class="icon-phone" aria-hidden="true"></span> 
                                    <a href="tel:<?php echo $telephone; ?>"><?php echo $telephone; ?></a>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($email) : ?>
                                <div class="agriculteur-email">
                                    <span class="icon-envelope" aria-hidden="true"></span> 
                                    <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
                                </div>
                            <?php endif; ?>
                            
                            <?php if ($site_web) : ?>
                                <div class="agriculteur-site">
                                    <span class="icon-link" aria-hidden="true"></span> 
                                    <a href="<?php echo $site_web; ?>" target="_blank">Site web</a>
                                </div>
                            <?php endif; ?>
                        </div>
                        
                        <?php if ($rsformData) : ?>
                            <div class="rsform-data">
                                <?php foreach ($rsformData['fields'] as $fieldName => $fieldValue) : ?>
                                    <?php if ($fieldValue && !in_array($fieldName, ['formId', 'formName'])) : ?>
                                        <div class="field field-rsform">
                                            <strong><?php echo htmlspecialchars($fieldName); ?>:</strong> 
                                            <?php echo htmlspecialchars($fieldValue); ?>
                                        </div>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                        
                        <div class="agriculteur-intro">
                            <?php echo HTMLHelper::_('content.prepare', $item->introtext); ?>
                        </div>
                        
                        <a href="<?php echo $item->link; ?>" class="btn btn-sm btn-outline-primary">
                            En savoir plus
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else : ?>
        <div class="alert alert-info">
            <span class="icon-info-circle" aria-hidden="true"></span>
            <span class="visually-hidden"><?php echo Text::_('INFO'); ?></span>
            <?php echo Text::_('MOD_AGRICULTEUR_LISTE_NO_MATCHING_RESULTS'); ?>
        </div>
    <?php endif; ?>
</div>
