<?php
/**
 * @version 3.0.0
 * @package RSForm! Pro
 * @copyright (C) 2007-2021 www.rsjoomla.com
 * @license GPL, https://www.gnu.org/copyleft/gpl.html
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\Router\Route;

// Setup the modal
if ($bsmodal) {
	echo HTMLHelper::_('bootstrap.renderModal', 'feedbackModal' . $module->id, array(
		'title' 	 => $title,
		'url' 		 => Route::_($form_url),
		'bodyHeight' => (int) $params->get('bsmodal_height', 70),
		'modalWidth' => (int) $params->get('bsmodal_width')
	), '');
} elseif ($jsmodal) {
	HTMLHelper::_('script', 'mod_rsform_feedback/simple-modal.js', array('relative' => true, 'version' => 'auto'));
}

Factory::getDocument()->addStyleDeclaration('
#feedback-'.$module->id.' a {
	background-color: '.htmlspecialchars($bg_color, ENT_COMPAT, 'utf-8').';
	border: solid 2px '.htmlspecialchars($border_color, ENT_COMPAT, 'utf-8').';
	color: '.htmlspecialchars($text_color, ENT_COMPAT, 'utf-8').';
	font-size: '.(int) $font_size.'px;
}
')
?>
<div id="feedback-<?php echo $module->id; ?>" class="feedback-container<?php echo htmlspecialchars($sfx, ENT_COMPAT, 'utf-8'); ?> feedback-position-<?php echo htmlspecialchars($position, ENT_COMPAT, 'utf-8'); ?>">
<?php
if ($bsmodal || $jsmodal)
{
	echo HTMLHelper::_('link', 'javascript:void(0);', $text, $attribs);
}
else
{
	echo HTMLHelper::_('link', Route::_($form_url), $text, $attribs);
}
?>
</div>
<?php
if ($jsmodal)
{
	// Load language
	Factory::getLanguage()->load('com_rsform', JPATH_SITE);

	// Must process form
	$formparams = Factory::getSession()->get('com_rsform.formparams.formId' . $formId);
	$post = Factory::getApplication()->input->post->get('form', array(), 'array');
	$class = '';
	if ((isset($post['formId']) && $post['formId'] == $formId) || ($formparams && !empty($formparams->formProcessed) && (($form = RSFormProHelper::getForm($formId)) && $form->ShowThankyou)))
	{
		$class = ' rsform-simple-js-modal-show-modal';
	}
	?>
	<div class="rsform-simple-js-modal<?php echo $class; ?>">
		<div class="rsform-simple-js-modal-content">
			<span class="rsform-simple-js-modal-close-button">×</span>
			<?php echo RSFormProHelper::displayForm($formId, true); ?>
		</div>
	</div>
<?php
}