<?php
/**
* @package RSForm!Pro
* @copyright (C) 2007-2019 www.rsjoomla.com
* @license GPL, http://www.gnu.org/copyleft/gpl.html
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

class plgSystemRsfppdfInstallerScript
{
	protected static $minJoomla = '3.7.0';
	protected static $minComponent = '3.0.0';
	protected static $minPHP = '5.4';

	public function preflight($type, $parent)
    {
		if ($type == 'uninstall')
		{
			return true;
		}

		try
        {
	        if (version_compare(PHP_VERSION, static::$minPHP, '<'))
	        {
		        throw new Exception('To use the RSForm! Pro PDF Plugin, a minimum PHP version of ' . static::$minPHP . ' is required. Please update your PHP version.', 'warning');
	        }

	        if (!function_exists('mb_internal_encoding') || !is_callable('mb_internal_encoding'))
	        {
		        throw new Exception('Please install and enable the Multibyte String library in your PHP installation: http://php.net/manual/en/book.mbstring.php');
	        }

	        $jversion = new JVersion();
	        if (!$jversion->isCompatible(static::$minJoomla))
	        {
		        throw new Exception('Please upgrade to at least Joomla! ' . static::$minJoomla . ' before continuing!');
	        }

	        if (!file_exists(JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/rsform.php'))
	        {
		        throw new Exception('Please install the RSForm! Pro component before continuing.');
	        }

	        if (!file_exists(JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/assets.php') || !file_exists(JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/version.php'))
	        {
		        throw new Exception('Please upgrade RSForm! Pro to at least version ' . static::$minComponent . ' before continuing!');
	        }

	        require_once JPATH_ADMINISTRATOR.'/components/com_rsform/helpers/version.php';
	        if (!class_exists('RSFormProVersion') || version_compare((string) new RSFormProVersion, static::$minComponent, '<'))
	        {
		        throw new Exception('Please upgrade RSForm! Pro to at least version ' . static::$minComponent . ' before continuing!');
	        }
        }
        catch (Exception $e)
        {
            JFactory::getApplication()->enqueueMessage($e->getMessage(), 'error');
            return false;
        }

        return true;
	}
	
	public function update($parent)
	{
		$this->copyFiles($parent);
		
		$db = JFactory::getDbo();
		$columns = $db->getTableColumns('#__rsform_pdfs');
		
		if (!isset($columns['useremail_userpass'])) {
			$db->setQuery("ALTER TABLE `#__rsform_pdfs` ADD `useremail_userpass` VARCHAR( 255 ) NOT NULL AFTER `useremail_layout`,".
						  "ADD `useremail_ownerpass` VARCHAR( 255 ) NOT NULL AFTER `useremail_userpass`,".
						  "ADD `adminemail_userpass` VARCHAR( 255 ) NOT NULL AFTER `adminemail_layout`,".
						  "ADD `adminemail_ownerpass` VARCHAR( 255 ) NOT NULL AFTER `adminemail_userpass`,".
						  "ADD `useremail_options` VARCHAR( 32 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'print,modify,copy,add' AFTER `useremail_ownerpass`,".
						  "ADD `adminemail_options` VARCHAR( 32 ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'print,modify,copy,add' AFTER `adminemail_ownerpass`");
			$db->execute();
		}

		// Let's make some columns mediumtext
		$changed = array('useremail_php', 'useremail_layout', 'adminemail_php', 'adminemail_layout');
		foreach ($changed as $column)
		{
			if (isset($columns[$column]) && $columns[$column] == 'text')
			{
				$db->setQuery("ALTER TABLE #__rsform_pdfs CHANGE " . $db->qn($column) . " " . $db->qn($column) . ' mediumtext');
				$db->execute();
			}
		}
		
		// Run our SQL file
		$this->runSQL($parent->getParent()->getPath('source'), 'install');
	}
	
	public function install($parent) {
		$this->copyFiles($parent);
	}
	
	protected function copyFiles($parent) {
		$app = JFactory::getApplication();
		$installer = $parent->getParent();
		$src = $installer->getPath('source').'/admin';
		$dest = JPATH_ADMINISTRATOR.'/components/com_rsform';
		
		if (!JFolder::copy($src, $dest, '', true))
		{
			$app->enqueueMessage('Could not copy to '.str_replace(JPATH_SITE, '', $dest).', please make sure destination is writable!', 'error');
		}
	}

	protected function runSQL($source, $file)
	{
		$db = JFactory::getDbo();
		$sqlfile = $source . '/sql/mysql/' . $file . '.sql';

		if (file_exists($sqlfile))
		{
			$buffer = file_get_contents($sqlfile);
			if ($buffer !== false)
			{
				$queries = $db->splitSql($buffer);
				foreach ($queries as $query)
				{
					$query = trim($query);
					if ($query != '')
					{
						$db->setQuery($query)->execute();
					}
				}
			}
		}
	}
	
	public function postflight($type, $parent) {
		if ($type == 'uninstall') {
			return true;
		}

		?>
		<style type="text/css">
		.version-history {
			margin: 0 0 2em 0;
			padding: 0;
			list-style-type: none;
		}
		.version-history > li {
			margin: 0 0 0.5em 0;
			padding: 0 0 0 4em;
			text-align:left;
			font-weight:normal;
		}
		.version-new,
		.version-fixed,
		.version-upgraded {
			float: left;
			font-size: 0.8em;
			margin-left: -4.9em;
			width: 4.5em;
			color: white;
			text-align: center;
			font-weight: bold;
			text-transform: uppercase;
			-webkit-border-radius: 4px;
			-moz-border-radius: 4px;
			border-radius: 4px;
		}

		.version-new {
			background: #7dc35b;
		}
		.version-fixed {
			background: #e9a130;
		}
		.version-upgraded {
			background: #61b3de;
		}
		</style>

		<h3>RSForm! Pro PDF Plugin v3.0.2 Changelog</h3>
		<ul class="version-history">
			<li><span class="version-new">New</span> Support for dompdf v2.0.x</li>
		</ul>
		<a class="btn btn-primary btn-large btn-lg" href="<?php echo JRoute::_('index.php?option=com_rsform&view=forms'); ?>">Manage Forms</a>
		<a class="btn btn-secondary" href="https://www.rsjoomla.com/support/documentation/rsform-pro/plugins-and-modules/rsform-pro-pdf-plugin.html" target="_blank">Read the documentation</a>
		<a class="btn btn-secondary" href="https://www.rsjoomla.com/support.html" target="_blank">Get Support!</a>
		<div style="clear: both;"></div>
		<?php
	}
}