<?php
define('_JEXEC', 1);
require_once __DIR__ . '/includes/defines.php';
require_once __DIR__ . '/includes/framework.php';

$db = JFactory::getDbo();
$query = $db->getQuery(true)
    ->select('s.SubmissionId, s.DateSubmitted, f.FieldValue AS email, x.FieldValue AS token')
    ->from($db->qn('#__rsform_submissions', 's'))
    ->join('INNER', $db->qn('#__rsform_submission_fields', 'f') . ' ON s.SubmissionId = f.SubmissionId')
    ->join('INNER', $db->qn('#__rsform_submission_extras', 'x') . ' ON s.SubmissionId = x.SubmissionId')
    ->where('f.FieldName = ' . $db->q('email'))
    ->where('x.FieldName = ' . $db->q('token'))
    ->where('s.FormId = 1')
    ->where('s.inscription IN ("25€/mois", "35€/mois", "45€/mois")');

$results = $db->setQuery($query)->loadObjectList();

foreach ($results as $row) {
    // Utiliser Joomla Mailer
    $mailer = JFactory::getMailer();
    $mailer->addRecipient($row->email);
    $mailer->setSubject("Mise à jour des produits - Labioléla");
    $mailer->isHtml(true);
    
    $body = "<p>Cliquez pour modifier vos produits :<br>
            <a href='https://labiolela.re/index.php/edition?token=".$row->token."&id=".$row->SubmissionId."'>
            Modifier mes informations</a></p>";
    
    $mailer->setBody($body);
    $mailer->Send();
}