<?php
// Fichier : test-api.php
// But : tester directement l'API OpenRouteService avec des coordonnées fixes

// Définir que la réponse sera en HTML
header('Content-Type: text/html; charset=utf-8');

// Activer l'affichage des erreurs pour le débogage
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>Test de l'API OpenRouteService</h1>";

// Coordonnées de test (La Réunion)
$startLng = 55.536384;  // Longitude
$startLat = -21.115141; // Latitude
$endLng = 55.450000;    // Longitude
$endLat = -21.200000;   // Latitude

echo "<p>Coordonnées de départ: [$startLat, $startLng]</p>";
echo "<p>Coordonnées d'arrivée: [$endLat, $endLng]</p>";

// Clé API OpenRouteService
$apiKey = '5b3ce3597851110001cf62480c7ae4d074084cd6aefd8f3652182e26';

try {
    // Construire le corps de la requête au format JSON
    $requestBody = [
        'coordinates' => [
            [$startLng, $startLat],
            [$endLng, $endLat]
        ],
        'instructions' => false
    ];
    
    $jsonBody = json_encode($requestBody);
    echo "<h2>Corps de la requête</h2>";
    echo "<pre>" . htmlspecialchars($jsonBody) . "</pre>";
    
    // Construction de l'URL de l'API OpenRouteService
    $url = "https://api.openrouteservice.org/v2/directions/driving-car";
    echo "<p>URL de l'API: " . htmlspecialchars($url) . "</p>";
    
    // Initialise une requête cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonBody);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Accept: application/json, application/geo+json, application/gpx+xml, img/png; charset=utf-8',
        'Authorization: ' . $apiKey,
        'Content-Type: application/json; charset=utf-8'
    ]);
    
    // Option pour voir les détails de la requête
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);
    
    echo "<h2>Envoi de la requête...</h2>";
    $response = curl_exec($ch);
    
    // Récupérer les informations de débogage
    rewind($verbose);
    $verboseLog = stream_get_contents($verbose);
    echo "<h2>Détails cURL</h2>";
    echo "<pre>" . htmlspecialchars($verboseLog) . "</pre>";
    
    // Gère les erreurs cURL
    if (curl_errno($ch)) {
        echo "<h2>Erreur cURL</h2>";
        echo "<p>Erreur: " . htmlspecialchars(curl_error($ch)) . "</p>";
        curl_close($ch);
        exit;
    }
    
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    echo "<p>Code HTTP reçu: $httpCode</p>";
    curl_close($ch);
    
    // Vérifier si la réponse est valide
    if ($httpCode != 200) {
        echo "<h2>Erreur API</h2>";
        echo "<p>Code HTTP: $httpCode</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
        exit;
    }
    
    // Analyser la réponse
    $responseData = json_decode($response, true);
    
    echo "<h2>Réponse de l'API</h2>";
    echo "<pre>" . htmlspecialchars(json_encode($responseData, JSON_PRETTY_PRINT)) . "</pre>";
    
    // Extraire et afficher la distance
    if (isset($responseData['features'][0]['properties']['summary']['distance'])) {
        $distance = $responseData['features'][0]['properties']['summary']['distance'];
        $distanceKm = $distance / 1000;
        echo "<h2>Distance calculée</h2>";
        echo "<p><strong>$distanceKm km</strong> ($distance mètres)</p>";
    } else {
        echo "<h2>Impossible de trouver la distance dans la réponse</h2>";
    }
    
} catch (Exception $e) {
    echo "<h2>Exception</h2>";
    echo "<p>Erreur: " . htmlspecialchars($e->getMessage()) . "</p>";
}
