const fs = require('fs');
const path = require('path');
const { execSync } = require('child_process');

// Fonction pour parcourir récursivement un répertoire
function walkDir(dir, callback) {
  fs.readdirSync(dir).forEach(f => {
    let dirPath = path.join(dir, f);
    let isDirectory = fs.statSync(dirPath).isDirectory();
    isDirectory ? walkDir(dirPath, callback) : callback(path.join(dir, f));
  });
}

// Vérifier la syntaxe de tous les fichiers JavaScript
console.log("Vérification de la syntaxe de tous les fichiers JavaScript...");

walkDir('/home/project', (filePath) => {
  if (filePath.endsWith('.js')) {
    console.log(`\nVérification de: ${filePath}`);
    try {
      execSync(`node --check ${filePath}`, { stdio: 'pipe' });
      console.log(`✅ Syntaxe correcte: ${filePath}`);
    } catch (err) {
      console.error(`❌ Erreur de syntaxe dans: ${filePath}`);
      console.error(err.stderr.toString());
      
      // Lire le contenu du fichier pour afficher la ligne problématique
      try {
        const content = fs.readFileSync(filePath, 'utf8');
        const lines = content.split('\n');
        
        // Extraire le numéro de ligne de l'erreur
        const match = err.stderr.toString().match(/line (\d+)/);
        if (match && match[1]) {
          const lineNum = parseInt(match[1]);
          console.log(`\nLigne ${lineNum}: ${lines[lineNum-1]}`);
          
          // Afficher quelques lignes avant et après pour le contexte
          const start = Math.max(0, lineNum - 3);
          const end = Math.min(lines.length, lineNum + 2);
          
          console.log("\nContexte:");
          for (let i = start; i < end; i++) {
            console.log(`${i+1}: ${lines[i]}`);
          }
        }
      } catch (readErr) {
        console.error(`Impossible de lire le fichier pour afficher le contexte: ${readErr}`);
      }
    }
  }
});

console.log("\nVérification terminée.");
