const fs = require('fs');
const { execSync } = require('child_process');

// Vérifier la syntaxe des fichiers principaux
const mainFiles = [
  '/home/project/js/geoloc.js',
  '/home/project/tmpl/assets/main.js'
];

console.log("Vérification finale de la syntaxe...");

mainFiles.forEach(filePath => {
  if (fs.existsSync(filePath)) {
    console.log(`\nVérification de: ${filePath}`);
    try {
      execSync(`node --check ${filePath}`, { stdio: 'inherit' });
      console.log(`✅ Syntaxe correcte: ${filePath}`);
    } catch (err) {
      console.error(`❌ Erreur de syntaxe dans: ${filePath}`);
    }
  } else {
    console.log(`⚠️ Fichier non trouvé: ${filePath}`);
  }
});

console.log("\nVérification terminée.");
