const fs = require('fs');
const path = require('path');

// Fonction pour parcourir récursivement un répertoire
function walkDir(dir, callback) {
  fs.readdirSync(dir).forEach(f => {
    let dirPath = path.join(dir, f);
    let isDirectory = fs.statSync(dirPath).isDirectory();
    isDirectory ? walkDir(dirPath, callback) : callback(path.join(dir, f));
  });
}

// Fonction pour rechercher une chaîne dans un fichier
function findString(filePath) {
  // Vérifier si c'est un fichier JavaScript ou HTML
  if (!filePath.endsWith('.js') && !filePath.endsWith('.php') && !filePath.endsWith('.html')) return;
  
  try {
    const content = fs.readFileSync(filePath, 'utf8');
    
    // Rechercher la chaîne "vol d'"directe"" avec différentes apostrophes
    const patterns = [
      "vol d'"directe"",
      "vol d'"directe"",
      "vol d\\'"directe"",
      "vol d\\\""directe""
    ];
    
    let found = false;
    
    patterns.forEach(pattern => {
      const index = content.indexOf(pattern);
      if (index !== -1) {
        found = true;
        
        // Extraire le contexte (50 caractères avant et après)
        const start = Math.max(0, index - 50);
        const end = Math.min(content.length, index + pattern.length + 50);
        const context = content.substring(start, end);
        
        console.log(`Trouvé "${pattern}" dans ${filePath}`);
        console.log(`Contexte: ...${context}...`);
        
        // Trouver le numéro de ligne
        const lines = content.substring(0, index).split('\n');
        const lineNum = lines.length;
        console.log(`Ligne: ${lineNum}`);
        
        // Afficher la ligne complète
        const allLines = content.split('\n');
        console.log(`Ligne complète: ${allLines[lineNum-1]}`);
        console.log('---');
      }
    });
    
    // Rechercher aussi ""directe"" seul pour détecter d'autres cas
    if (!found) {
      const index = content.indexOf(""directe"");
      if (index !== -1) {
        // Extraire le contexte (50 caractères avant et après)
        const start = Math.max(0, index - 50);
        const end = Math.min(content.length, index + 6 + 50);
        const context = content.substring(start, end);
        
        console.log(`Trouvé ""directe"" dans ${filePath}`);
        console.log(`Contexte: ...${context}...`);
        
        // Trouver le numéro de ligne
        const lines = content.substring(0, index).split('\n');
        const lineNum = lines.length;
        console.log(`Ligne: ${lineNum}`);
        
        // Afficher la ligne complète
        const allLines = content.split('\n');
        console.log(`Ligne complète: ${allLines[lineNum-1]}`);
        console.log('---');
      }
    }
  } catch (err) {
    console.error(`Erreur lors de la lecture de ${filePath}:`, err);
  }
}

// Répertoire de départ
const startDir = '/home/project';

// Parcourir tous les fichiers
console.log(`Recherche de "vol d'"directe"" à partir de: ${startDir}`);
walkDir(startDir, findString);

console.log("Recherche terminée");
