const fs = require('fs');
const path = require('path');
const { execSync } = require('child_process');

// Fonction pour parcourir récursivement un répertoire
function walkDir(dir, callback) {
  fs.readdirSync(dir).forEach(f => {
    let dirPath = path.join(dir, f);
    let isDirectory = fs.statSync(dirPath).isDirectory();
    isDirectory ? walkDir(dirPath, callback) : callback(path.join(dir, f));
  });
}

// Fonction pour corriger les problèmes de syntaxe dans un fichier
function fixSyntaxIssues(filePath) {
  if (!filePath.endsWith('.js')) return;
  
  try {
    let content = fs.readFileSync(filePath, 'utf8');
    let originalContent = content;
    
    // Remplacer toutes les occurrences de "distance directe" par "distance directe"
    content = content.replace(/"distance directe"/g, '"distance directe"');
    
    // Remplacer toutes les occurrences de "directe" non entourées de guillemets
    content = content.replace(/\b("directe")\b(?!['":])/g, '"directe"');
    
    // Remplacer les cas spécifiques qui pourraient causer l'erreur
    content = content.replace(/console\.log\(`Distance "directe"/g, 'console.log(`Distance directe');
    content = content.replace(/console\.log\(`Utilisation du fallback/g, 'console.log(`Utilisation du fallback');
    
    // Vérifier si des modifications ont été apportées
    if (content !== originalContent) {
      console.log(`✅ Corrections appliquées à: ${filePath}`);
      fs.writeFileSync(filePath, content, 'utf8');
      
      // Vérifier la syntaxe après correction
      try {
        execSync(`node --check ${filePath}`, { stdio: 'pipe' });
        console.log(`   Syntaxe correcte après correction: ${filePath}`);
      } catch (err) {
        console.error(`❌ Erreur de syntaxe persistante dans: ${filePath}`);
        console.error(err.stderr.toString());
      }
    }
  } catch (err) {
    console.error(`Erreur lors de la correction de ${filePath}: ${err}`);
  }
}

// Répertoire de départ
const startDir = '/home/project';

// Rechercher et corriger les problèmes
console.log("Recherche et correction des problèmes de syntaxe dans tous les fichiers JavaScript...");
walkDir(startDir, fixSyntaxIssues);

// Corriger spécifiquement les fichiers principaux
const mainFiles = [
  '/home/project/js/geoloc.js',
  '/home/project/tmpl/assets/main.js'
];

console.log("\nCorrection spécifique des fichiers principaux...");
mainFiles.forEach(filePath => {
  if (fs.existsSync(filePath)) {
    console.log(`Correction du fichier principal: ${filePath}`);
    
    // Lire le contenu
    let content = fs.readFileSync(filePath, 'utf8');
    
    // Remplacer toutes les occurrences problématiques
    content = content.replace(/"distance directe"/g, '"distance directe"');
    content = content.replace(/distance "directe"/g, 'distance directe');
    content = content.replace(/\bdirecte\b(?!['":])/g, '"directe"');
    
    // Écrire le contenu corrigé
    fs.writeFileSync(filePath, content, 'utf8');
    
    // Vérifier la syntaxe après correction
    try {
      execSync(`node --check ${filePath}`, { stdio: 'pipe' });
      console.log(`✅ Syntaxe correcte après correction: ${filePath}`);
    } catch (err) {
      console.error(`❌ Erreur de syntaxe persistante dans: ${filePath}`);
      console.error(err.stderr.toString());
    }
  }
});

console.log("\nCorrections terminées.");
