const fs = require('fs');

// Fonction pour corriger les problèmes dans main.js
function fixMainJsFile() {
  const filePath = '/home/project/tmpl/assets/main.js';
  
  if (!fs.existsSync(filePath)) {
    console.error(`Fichier non trouvé: ${filePath}`);
    return;
  }
  
  try {
    let content = fs.readFileSync(filePath, 'utf8');
    
    // Remplacer toutes les occurrences problématiques
    content = content.replace(/"distance "directe""/g, '"distance directe"');
    content = content.replace(/distance "directe"/g, 'distance directe');
    
    // Corriger les commentaires
    content = content.replace(/\/\/ Fonction pour calculer la "distance "directe"" \(formule Haversine\)/g, 
                             '// Fonction pour calculer la distance directe (formule Haversine)');
    
    content = content.replace(/\/\/ Fallback: "distance "directe""/g, 
                             '// Fallback: distance directe');
    
    // Écrire le contenu corrigé
    fs.writeFileSync(filePath, content, 'utf8');
    console.log(`✅ Corrections appliquées à: ${filePath}`);
    
    // Vérifier la syntaxe
    const { execSync } = require('child_process');
    try {
      execSync(`node --check ${filePath}`, { stdio: 'pipe' });
      console.log(`✅ Syntaxe correcte pour ${filePath}`);
    } catch (err) {
      console.error(`❌ Erreur de syntaxe dans ${filePath}:`);
      console.error(err.stderr.toString());
    }
  } catch (err) {
    console.error(`Erreur lors de la correction de ${filePath}: ${err}`);
  }
}

// Exécuter la correction
console.log("Correction du fichier main.js...");
fixMainJsFile();
console.log("Correction terminée.");
