/**
 * @package     Joomla.Site
 * @subpackage  mod_agriculteur_profil
 *
 * Styles pour le module de profil d'agriculteur bio
 */


/* Variables principales */
:root {
    --primary-color: #3c8f44;
    --secondary-color: #f8f9fa;
    --accent-color: #e67e22;
    --text-color: #333;
    --light-text: #6c757d;
}

/* Styles généraux */
.agriculteur-profil {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    color: var(--text-color);
    line-height: 1.6;
}

/* Header */
.profile-header {
    position: relative;
    height: 50vh;
    min-height: 300px;
    overflow: hidden;
    margin-bottom: 2rem;
}

.cover-photo {
    width: 100%;
    height: 100%;
    object-fit: cover;
    filter: brightness(0.85);
}

.header-content {
    position: absolute;
    bottom: 0;
    left: 0;
    width: 100%;
    padding: 2rem;
    background: linear-gradient(0deg, rgba(0,0,0,0.7) 0%, rgba(0,0,0,0) 100%);
    color: white;
}

.logo-container {
    position: absolute;
    top: 2rem;
    left: 2rem;
    width: 120px;
    height: 120px;
    border-radius: 50%;
    overflow: hidden;
    border: 4px solid white;
    background-color: white;
}

.logo-img {
    width: 100%;
    height: 100%;
    object-fit: contain;
}

.map-button {
    position: absolute;
    top: 2rem;
    right: 2rem;
}

/* Titre et sous-titres */
.farm-title {
    font-size: 2.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    color: white;
}

.section-title {
    color: var(--primary-color);
    font-weight: 600;
    margin-top: 2rem;
    margin-bottom: 1rem;
    padding-bottom: 0.5rem;
    border-bottom: 2px solid var(--primary-color);
}

/* Badges et étiquettes */
.category-badge {
    background-color: var(--primary-color);
    color: white;
    margin-right: 0.5rem;
    margin-bottom: 0.5rem;
    transition: all 0.3s;
}

.category-badge:hover {
    background-color: var(--accent-color);
    transform: translateY(-2px);
}

/* Cartes d'information */
.info-card {
    background-color: var(--secondary-color);
    border-radius: 10px;
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    transition: all 0.3s;
}

.info-card:hover {
    box-shadow: 0 10px 15px rgba(0,0,0,0.1);
    transform: translateY(-5px);
}

.contact-icon {
    color: var(--primary-color);
    font-size: 1.2rem;
    margin-right: 0.5rem;
}

/* Sections de produits */
.products-section {
    margin-top: 2rem;
}

.product-list {
    display: flex;
    flex-wrap: wrap;
    gap: 1rem;
}

/* Galerie photos */
.gallery {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
    gap: 1rem;
    margin-top: 1rem;
}

.gallery-item {
    border-radius: 10px;
    overflow: hidden;
    height: 200px;
}

.gallery-img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s;
}

.gallery-img:hover {
    transform: scale(1.05);
}

/* Conteneurs vidéo */
.video-container {
    margin-top: 1rem;
}

.video-responsive {
    position: relative;
    overflow: hidden;
    padding-top: 56.25%;
    border-radius: 10px;
}

.video-responsive iframe {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    border: 0;
}

/* Pied de page */
.footer {
    background-color: var(--primary-color);
    color: white;
    text-align: center;
    padding: 2rem 0;
    margin-top: 4rem;
}

/* Adaptations responsive */
@media (max-width: 768px) {
    .profile-header {
        height: 30vh;
    }
    
    .logo-container {
        width: 80px;
        height: 80px;
        top: 1rem;
        left: 1rem;
    }
    
    .map-button {
        top: 1rem;
        right: 1rem;
    }
    
    .farm-title {
        font-size: 1.8rem;
    }
    
    .header-content {
        padding: 1rem;
    }
}

/* Jours de réception */
.reception-days {
    margin-bottom: 1rem;
}

.reception-day {
    display: inline-block;
    background-color: var(--primary-color);
    color: white;
    padding: 0.35rem 0.75rem;
    border-radius: 30px;
    margin-right: 0.5rem;
    margin-bottom: 0.5rem;
    font-size: 0.85rem;
}

/* Informations de contact */
.contact-list li {
    margin-bottom: 0.75rem;
}

.contact-list a {
    color: var(--primary-color);
    text-decoration: none;
}

.contact-list a:hover {
    color: var(--accent-color);
    text-decoration: underline;
}

/* Compatibilité Joomla */
.agriculteur-profil .page-header {
    display: none; /* Cacher le titre de page Joomla si nécessaire */
}

.agriculteur-profil .container-fluid {
    padding: 0;
}

.agriculteur-profil h1,
.agriculteur-profil h2,
.agriculteur-profil h3,
.agriculteur-profil h4,
.agriculteur-profil h5,
.agriculteur-profil h6 {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
}

/* Bouton "Y aller" */
.btn-success {
    background-color: var(--primary-color);
    border-color: var(--primary-color);
}

.btn-success:hover,
.btn-success:focus {
    background-color: var(--accent-color);
    border-color: var(--accent-color);
}